#include "MCamGeom.h"

#include <math.h>
#include <TClonesArray.h>
#include "TCanvas.h"

#include "MHexagon.h"

ClassImp(MPixGeom)
ClassImp(MCamGeom)

MPixGeom::MPixGeom(Float_t x, Float_t y, Float_t r ) 
{ 
  //  default constructor
  fX = x ; 
  fY = y ; 
  fR = r ; 
} 


void MPixGeom::Print() 
{ 
  //   information about a pixel
  cout << "MPixGeom:  x= " << fX
       << "  y= " << fY
       << "  r= " << fR
       << endl ; 
} 

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


MCamGeom::MCamGeom (Int_t type ) 
{ 
  //    default constructor

  if ( type == 1 ) {
    // set up the Geometry of CT1 
    
    fNbPixels = 127 ; 
    fPixels = new TObjArray ( fNbPixels ) ; 
    
    CreateCT1() ; 
  } 
  else { 
    // set up the standard Geometry MAGIC
    fNbPixels = 577 ; 
    fPixels = new TObjArray ( fNbPixels ) ; 

    CreateMagic() ; 
  } 
} 

void MCamGeom::Draw( Option_t * ) 
{ 
  TCanvas *can = new TCanvas("can", "Camera Geometry", 4 ) ; 
  
  //   set the range of the canvas
  if ( fNbPixels == 127 )        // case of CT1
    can->Range(-175, -175, 175, 175 ) ; 
  else
    can->Range(-600, -600, 600, 600 ) ; 

  //   draw all pixels
  
  for ( Int_t i=0; i < fNbPixels ; i++ ) {   
    MHexagon *el = new MHexagon ( GetX(i) , GetY(i) , GetR(i) )    ;   
    el->Draw() ;     
  } 
  
} 

void MCamGeom::Print() 
{ 
  //   Print Information about the Geometry of the camera
  cout << "++++++++++++++++++++++++++++++++++++++++" << endl ; 
  cout << " Number of Pixels: " << fNbPixels << endl ; 

  for ( Int_t i=0; i<fNbPixels; i++ ) { 
    cout << " Pixel: " << i << "  " ; 
    ((MPixGeom *)fPixels->At(i))->Print() ;  
  } 
} 

Int_t MCamGeom::GetNbPixels () 
{ 
  //   return the Number of pixels in the MCamGeom class
  return fNbPixels ; 

} 
Float_t MCamGeom::GetX(Int_t iPix) 
{
  //   return the X coordinate of Pixel iPix 

  return ( ((MPixGeom*) fPixels->At(iPix))->GetX() ) ; 
} 

Float_t MCamGeom::GetY(Int_t iPix) 
{
  //   return the Y coordinate of Pixel iPix 
  return ( ((MPixGeom*) fPixels->At(iPix))->GetY() ) ;  
}

Float_t MCamGeom::GetR(Int_t iPix) 
{
  //   return the radius r of Pixel iPix 
  return ( ((MPixGeom*) fPixels->At(iPix))->GetR() ) ; 
}


void MCamGeom::CreateMagic() 
{ 
  //   fill the geometry class with the coordinates of the MAGIC camera
  cout << " Create Magic geometry " << endl ;

  //   here define the hardwire things of the magic telescope
  //
  Float_t xtemp[577] = { 
    0.000,   30.000,   15.000,  -15.000,  -30.000,  -15.000,   15.000,   60.000,
   45.000,   30.000,    0.000,  -30.000,  -45.000,  -60.000,  -45.000,  -30.000,
    0.000,   30.000,   45.000,   90.000,   75.000,   60.000,   45.000,   15.000,
  -15.000,  -45.000,  -60.000,  -75.000,  -90.000,  -75.000,  -60.000,  -45.000,
  -15.000,   15.000,   45.000,   60.000,   75.000,  120.000,  105.000,   90.000,
   75.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,  -75.000,  -90.000,
 -105.000, -120.000, -105.000,  -90.000,  -75.000,  -60.000,  -30.000,    0.000,
   30.000,   60.000,   75.000,   90.000,  105.000,  150.000,  135.000,  120.000,
  105.000,   90.000,   75.000,   45.000,   15.000,  -15.000,  -45.000,  -75.000,
  -90.000, -105.000, -120.000, -135.000, -150.000, -135.000, -120.000, -105.000,
  -90.000,  -75.000,  -45.000,  -15.000,   15.000,   45.000,   75.000,   90.000,
  105.000,  120.000,  135.000,  180.000,  165.000,  150.000,  135.000,  120.000,
  105.000,   90.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,  -90.000,
 -105.000, -120.000, -135.000, -150.000, -165.000, -180.000, -165.000, -150.000,
 -135.000, -120.000, -105.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,
   60.000,   90.000,  105.000,  120.000,  135.000,  150.000,  165.000,  210.000,
  195.000,  180.000,  165.000,  150.000,  135.000,  120.000,  105.000,   75.000,
   45.000,   15.000,  -15.000,  -45.000,  -75.000, -105.000, -120.000, -135.000,
 -150.000, -165.000, -180.000, -195.000, -210.000, -195.000, -180.000, -165.000,
 -150.000, -135.000, -120.000, -105.000,  -75.000,  -45.000,  -15.000,   15.000,
   45.000,   75.000,  105.000,  120.000,  135.000,  150.000,  165.000,  180.000,
  195.000,  240.000,  225.000,  210.000,  195.000,  180.000,  165.000,  150.000,
  135.000,  120.000,   90.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,
  -90.000, -120.000, -135.000, -150.000, -165.000, -180.000, -195.000, -210.000,
 -225.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000, -150.000,
 -135.000, -120.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,   60.000,
   90.000,  120.000,  135.000,  150.000,  165.000,  180.000,  195.000,  210.000,
  225.000,  270.000,  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,
  165.000,  150.000,  135.000,  105.000,   75.000,   45.000,   15.000,  -15.000,
  -45.000,  -75.000, -105.000, -135.000, -150.000, -165.000, -180.000, -195.000,
 -210.000, -225.000, -240.000, -255.000, -270.000, -255.000, -240.000, -225.000,
 -210.000, -195.000, -180.000, -165.000, -150.000, -135.000, -105.000,  -75.000,
  -45.000,  -15.000,   15.000,   45.000,   75.000,  105.000,  135.000,  150.000,
  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,  255.000,  300.000,
  285.000,  270.000,  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,
  165.000,  150.000,  120.000,   90.000,   60.000,   30.000,    0.000,  -30.000,
  -60.000,  -90.000, -120.000, -150.000, -165.000, -180.000, -195.000, -210.000,
 -225.000, -240.000, -255.000, -270.000, -285.000, -300.000, -285.000, -270.000,
 -255.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000, -150.000,
 -120.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,   60.000,   90.000,
  120.000,  150.000,  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,
  255.000,  270.000,  285.000,  330.000,  315.000,  300.000,  285.000,  270.000,
  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,  165.000,  135.000,
  105.000,   75.000,   45.000,   15.000,  -15.000,  -45.000,  -75.000, -105.000,
 -135.000, -165.000, -180.000, -195.000, -210.000, -225.000, -240.000, -255.000,
 -270.000, -285.000, -300.000, -315.000, -330.000, -315.000, -300.000, -285.000,
 -270.000, -255.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000,
 -135.000, -105.000,  -75.000,  -45.000,  -15.000,   15.000,   45.000,   75.000,
  105.000,  135.000,  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,
  255.000,  270.000,  285.000,  300.000,  315.000,  360.000,  330.000,  300.000,
  270.000,  240.000,  210.000,  150.000,   90.000,   30.000,  -30.000,  -90.000,
 -150.000, -210.000, -240.000, -270.000, -300.000, -330.000, -360.000, -360.000,
 -330.000, -300.000, -270.000, -240.000, -210.000, -150.000,  -90.000,  -30.000,
   30.000,   90.000,  150.000,  210.000,  240.000,  270.000,  300.000,  330.000,
  360.000,  420.000,  390.000,  360.000,  330.000,  300.000,  270.000,  240.000,
  180.000,  120.000,   60.000,    0.000,  -60.000, -120.000, -180.000, -240.000,
 -270.000, -300.000, -330.000, -360.000, -390.000, -420.000, -420.000, -390.000,
 -360.000, -330.000, -300.000, -270.000, -240.000, -180.000, -120.000,  -60.000,
    0.000,   60.000,  120.000,  180.000,  240.000,  270.000,  300.000,  330.000,
  360.000,  390.000,  420.000,  480.000,  450.000,  420.000,  390.000,  360.000,
  330.000,  300.000,  270.000,  210.000,  150.000,   90.000,   30.000,  -30.000,
  -90.000, -150.000, -210.000, -270.000, -300.000, -330.000, -360.000, -390.000,
 -420.000, -450.000, -480.000, -480.000, -450.000, -420.000, -390.000, -360.000,
 -330.000, -300.000, -270.000, -210.000, -150.000,  -90.000,  -30.000,   30.000,
   90.000,  150.000,  210.000,  270.000,  300.000,  330.000,  360.000,  390.000,
  420.000,  450.000,  480.000,  540.000,  510.000,  480.000,  450.000,  420.000,
  390.000,  360.000,  330.000,  300.000,  240.000,  180.000,  120.000,   60.000,
    0.000,  -60.000, -120.000, -180.000, -240.000, -300.000, -330.000, -360.000,
 -390.000, -420.000, -450.000, -480.000, -510.000, -540.000, -540.000, -510.000,
 -480.000, -450.000, -420.000, -390.000, -360.000, -330.000, -300.000, -240.000,
 -180.000, -120.000,  -60.000,    0.000,   60.000,  120.000,  180.000,  240.000,
  300.000,  330.000,  360.000,  390.000,  420.000,  450.000,  480.000,  510.000,
  540.000 
  } ; 

  Float_t ytemp[577] = { 
    0.000,    0.000,   25.981,   25.981,    0.000,  -25.981,  -25.981,    0.000,
   25.981,   51.961,   51.961,   51.961,   25.981,    0.000,  -25.981,  -51.961,
  -51.961,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,   77.942,
   77.942,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
  -77.942,  -77.942,  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,
   77.942,  103.923,  103.923,  103.923,  103.923,  103.923,   77.942,   51.961,
   25.981,    0.000,  -25.981,  -51.961,  -77.942, -103.923, -103.923, -103.923,
 -103.923, -103.923,  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,
   77.942,  103.923,  129.904,  129.904,  129.904,  129.904,  129.904,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -129.904, -129.904, -129.904, -129.904, -129.904, -103.923,
  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,
  129.904,  155.885,  155.885,  155.885,  155.885,  155.885,  155.885,  155.885,
  129.904,  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,
  -77.942, -103.923, -129.904, -155.885, -155.885, -155.885, -155.885, -155.885,
 -155.885, -155.885, -129.904, -103.923,  -77.942,  -51.961,  -25.981,    0.000,
   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,  181.865,  181.865,
  181.865,  181.865,  181.865,  181.865,  181.865,  181.865,  155.885,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -155.885, -181.865, -181.865, -181.865, -181.865, -181.865,
 -181.865, -181.865, -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,
  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,
  181.865,  207.846,  207.846,  207.846,  207.846,  207.846,  207.846,  207.846,
  207.846,  207.846,  181.865,  155.885,  129.904,  103.923,   77.942,   51.961,
   25.981,    0.000,  -25.981,  -51.961,  -77.942, -103.923, -129.904, -155.885,
 -181.865, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846,
 -207.846, -207.846, -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,
  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,
  181.865,  207.846,  233.827,  233.827,  233.827,  233.827,  233.827,  233.827,
  233.827,  233.827,  233.827,  233.827,  207.846,  181.865,  155.885,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -233.827, -233.827,
 -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -207.846,
 -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,  -25.981,    0.000,
   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,  181.865,  207.846,
  233.827,  259.808,  259.808,  259.808,  259.808,  259.808,  259.808,  259.808,
  259.808,  259.808,  259.808,  259.808,  233.827,  207.846,  181.865,  155.885,
  129.904,  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,
  -77.942, -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808,
 -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808,
 -259.808, -259.808, -233.827, -207.846, -181.865, -155.885, -129.904, -103.923,
  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,
  129.904,  155.885,  181.865,  207.846,  233.827,  259.808,  285.788,  285.788,
  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,
  285.788,  285.788,  259.808,  233.827,  207.846,  181.865,  155.885,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788,
 -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788,
 -285.788, -285.788, -285.788, -259.808, -233.827, -207.846, -181.865, -155.885,
 -129.904, -103.923,  -77.942,  -51.961,  -25.981,   34.641,   86.603,  138.564,
  190.526,  242.487,  294.449,  329.090,  329.090,  329.090,  329.090,  329.090,
  329.090,  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,
  -86.603, -138.564, -190.526, -242.487, -294.449, -329.090, -329.090, -329.090,
 -329.090, -329.090, -329.090, -294.449, -242.487, -190.526, -138.564,  -86.603,
  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,  294.449,  346.410,
  381.051,  381.051,  381.051,  381.051,  381.051,  381.051,  381.051,  346.410,
  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,  -86.603,
 -138.564, -190.526, -242.487, -294.449, -346.410, -381.051, -381.051, -381.051,
 -381.051, -381.051, -381.051, -381.051, -346.410, -294.449, -242.487, -190.526,
 -138.564,  -86.603,  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,
  294.449,  346.410,  398.372,  433.013,  433.013,  433.013,  433.013,  433.013,
  433.013,  433.013,  433.013,  398.372,  346.410,  294.449,  242.487,  190.526,
  138.564,   86.603,   34.641,  -34.641,  -86.603, -138.564, -190.526, -242.487,
 -294.449, -346.410, -398.372, -433.013, -433.013, -433.013, -433.013, -433.013,
 -433.013, -433.013, -433.013, -398.372, -346.410, -294.449, -242.487, -190.526,
 -138.564,  -86.603,  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,
  294.449,  346.410,  398.372,  450.333,  484.974,  484.974,  484.974,  484.974,
  484.974,  484.974,  484.974,  484.974,  484.974,  450.333,  398.372,  346.410,
  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,  -86.603,
 -138.564, -190.526, -242.487, -294.449, -346.410, -398.372, -450.333, -484.974,
 -484.974, -484.974, -484.974, -484.974, -484.974, -484.974, -484.974, -484.974,
 -450.333, -398.372, -346.410, -294.449, -242.487, -190.526, -138.564,  -86.603,
 -34.641
  } ; 

  Float_t rtemp[577] = { 
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,  
    60.00  } ; 
  
  //   fill the pixels list with this data
  
  for ( Int_t i = 0 ; i< fNbPixels ; i++ ) {     
    fPixels->Add( new MPixGeom(xtemp[i], ytemp[i], rtemp[i]) ) ;     
  }   
} 

void MCamGeom::CreateCT1() 
{  
  //   fill the geometry class with the coordinates of the CT1 camera
   cout << " Create CT1 geometry " << endl ; 
   //      use a function from Martin Kestel
   
   float  fpixdiameter = 21. ;    // units are cm 
   int ring_counter=1, ipix; 
   int num_pix_this_ring;
   int new_ring_start, end_this_ring;
   int end_last_ring = 1; 
   float fang, ffrac_ang, frad;
   float pi=4.*atan(1.);

   //  add the first pixel to the list 

   fPixels->Add( new MPixGeom(  0. ,0., fpixdiameter ) ) ; 
   for (ring_counter=1;ring_counter<7;ring_counter++) {
     /* calc. numofpix in ring number i first */
     num_pix_this_ring = ring_counter*6;
     
     /* get then the start-of-ring pixel number */
     new_ring_start = end_last_ring;
     
     /* .... this means the ring ends with pixnum ... */
     end_this_ring = end_last_ring + num_pix_this_ring;
     
     /* calc. coords for this ring counting from the 
	starting number to the ending number */
     for (ipix = 0; 
	  ipix < num_pix_this_ring; 
	  ipix++) {
       fang = 60./(float)ring_counter * (float)ipix;
       ffrac_ang = fang - 60.*((int)(floor(fang/60.)));
       fang *= pi/180.;
       ffrac_ang *= pi/180.;
       frad = (float)ring_counter * fpixdiameter ;
       frad *= sqrt(3.)/(2.*sin(2./3.*pi-ffrac_ang));
      
       //   fill the ObjArray with the pixels data ; 

       fPixels->Add( new MPixGeom(  frad * cos(fang) ,frad * sin(fang) , fpixdiameter ) ) ; 
     }
    
    /* set the end-of-ring number correctly */
    end_last_ring = end_this_ring ;
  }

} 

