/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Wolfgang Wittek , 7/2004 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////////
//
// MSkyCamTrans
//
//     container holding the parameters of the transformation from
//     sky directions 'a' (projected onto the camera) 
//     to positions 'b' in the camera
//
//                                          ( cos(fAlfa)   -sin(fAlfa) )
//      b = fLambda * fA * a + fD      fA = (                        )
//             ^       ^        ^           ( sin(fAlfa)    cos(fAlfa) )
//             |       |        |
//           scale  rotation  shift 
//          factor  matrix
//
//     fNumIter             number of iterations
//     fNdof                number of degrees of freedom
//     fChiSquare           chi-square value
//     fChiSquareProb       chi-square probability
//
// The units are assumed to be 
//     [degrees]  for  fAlfa
//     [mm]       for  a, b, fD
//     [1]        for  fLambda                       
//
//
// The container is filled by  the task 'MTelAxisFromStars' 
//
///////////////////////////////////////////////////////////////////////////


#include "MSkyCamTrans.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MSkyCamTrans);

using namespace std;

// ---------------------------------------------------------------------
//
//
//
MSkyCamTrans::MSkyCamTrans(const char *name, const char *title)
{
    fName  = name  ? name  : "MSkyCamTrans";
    fTitle = title ? title : "Sky-Cam transformation parameters";
}

// ---------------------------------------------------------------------
//
//
//
void MSkyCamTrans::SetParameters(Double_t &lambda, Double_t &alfa, 
     Double_t a[2][2], Double_t d[2],  Double_t errd[2][2], 
     Int_t &nstars,    Int_t &numiter,  
     Int_t &ndof,      Double_t &chisquare,        Double_t &chisquareprob)
{
  fLambda = lambda;
  fAlfa   = alfa;
    
  fA[0][0] = a[0][0];
  fA[0][1] = a[0][1];
  fA[1][0] = a[1][0];
  fA[1][1] = a[1][1];

  fD[0] = d[0];
  fD[1] = d[1];

  fErrD[0][0] = errd[0][0];
  fErrD[0][1] = errd[0][1];
  fErrD[1][0] = errd[1][0];
  fErrD[1][1] = errd[1][1];

  fNStars        = nstars;
  fNumIter       = numiter;
  fNdof          = ndof;
  fChiSquare     = chisquare;
  fChiSquareProb = chisquareprob;
}
// ---------------------------------------------------------------------












