#ifndef MREADTREE_H
#define MREADTREE_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class TFile;
class TTree;

class MReadTree : public MTask
{
private:
    TFile  *fFile;       // Pointer to file
    TTree  *fTree;       // Pointer to tree

    UInt_t  fNumEntry;   // Number of actual entry
    UInt_t  fNumEntries; // Number of Events in Tree

    TString fFileName;   // Name of File
    TString fTreeName;   // Name of Tree

public:
    MReadTree(const char *filename, const char *treename, const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    Bool_t GetEvent() ; 

    Bool_t DecEventNum(UInt_t dec=1); // decrease number of event (position in tree)
    Bool_t IncEventNum(UInt_t inc=1); // increase number of event (position in tree)
    Bool_t SetEventNum(UInt_t nr);    // set number of event (position in tree)
    UInt_t GetEventNum() {return fNumEntry;}
    UInt_t GetEntries() {return fNumEntries;}

    ClassDef(MReadTree, 1)	// Reads one tree
};

#endif
