#ifndef MGDISPLAYADC_H
#define MGDISPLAYADC_H

#ifndef ROOT_TFrame
#include <TGFrame.h> // TGTransientFrame
#endif

class MHistosAdc;
class TGListBox;
class TGTextButton;
class TRootEmbeddedCanvas;
class TCanvas;
class TGVSlider;
class TGRadioButton;

class MGDisplayAdc : public TGTransientFrame {
    private:
	
	MHistosAdc *fHists;		// Pointer to Container with the histograms
	
	// Create a main frame with a number of different buttons.
	//   
	TGCompositeFrame  *fFrameTop ;   // top part of the main window
	TGCompositeFrame  *fFrameLow ;   // low part of the main window
  
	TGVerticalFrame   *fFT1, *fFT2, *fFT3 ;
	
	TGListBox         *fHistoList ;
	TGTextButton      *fButtonPrev, *fButtonNext , *fButtonReset ;
	
	TRootEmbeddedCanvas  *fECanv , *fECanvLow;

	TGTextButton   *fButtonSave, *fButtonPrint, *fButtonPrintAll, *fButtonClose ; 
	
	TCanvas            *fCanv ;	
	
	
	//for sliders
	
	TGVSlider       *fVslider1;
	
       
	
  
    public:
	
	//for radio buttons

	TGRadioButton *fRadio[3];

	
        Int_t    fHistoType;
        Bool_t    fHistoLock; 
	//
			
	
	TGPicture *fPicture;  
	TCanvas *fCanvas;
	
	MGDisplayAdc(MHistosAdc *fHists , 
		     const TGWindow *p, const TGWindow *main, 
		     UInt_t w, UInt_t h, 
		     UInt_t options = kMainFrame | kVerticalFrame ) ;
	
	~MGDisplayAdc(); 
  
	void  CloseWindow()  ;
       
	
	Bool_t BuildHistoList(Int_t type=1) ;
	
	Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
  
} ; 

#endif


