#ifndef MGEVENTDISPMAIN_H
#define MGEVENTDISPMAIN_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif


class TGMenuBar;
class TGPopupMenu;
class TGTab;
class TGTextButton;
class TGListBox;
class TGPictureButton;
class TGFileContainer;
class TGListView;
class TGHorizontal3DLine;
class TGLabel ; 
class TGTextEntry ; 
class TGTextBuffer; 

class MGEventDispMain : public TGTransientFrame {
 private:
  
  //
  // Create a main frame with a number of different buttons.
  //

  //   some member not connected with Gui 
  
  Char_t            fInputFile[256] ; 

  //  the things for the menu bar 
    
  TGMenuBar         *fMenuBar ; 
  TGPopupMenu       *fFileMenu ;
  TGHorizontal3DLine *fLineSep1, *fLineSep2 ; 


  //   divide the Window in two different parts
  
  TGCompositeFrame  *fFrameTop ;   // top part of the main window
  TGCompositeFrame  *fFrameLow ;   // low part of the main window
  TGTab             *fTab      ;   // different tabs in the low window
  
  //     the horizontal frame in the top part

  TGHorizontalFrame *fTop1 ; 
  
  //   the buttons in the Top Part
  
  TGTextButton      *fButFadcDispEvts ; 
  TGTextButton      *fButFadcDispPed  ; 
  TGTextButton      *fButFadcDispCal  ; 
  
  //   the things in the file selector

  TGCompositeFrame  *fTabF1 ;                       // first tab of low part 
  TGCompositeFrame  *fTabF1a, *fTabF1b, *fTabF1c ;  // subpart of the file selector in low window

  TGLabel           *fLabFileName ; 
  TGTextEntry       *fTxtFileName ; 
  TGTextBuffer      *fTxtBufFileName ; //!
  TGTextButton      *fButFileReset ; 
 
  TGLabel           *fLabDir ; 
  TGListBox         *fDir ; 
  TGPictureButton   *fCdup, *fListMode, *fDetail ; 
 
  TGFileContainer   *fFileCont ; 
  TGListView        *fFileView ;

  //     Layout hints for different uses 
   
  TGLayoutHints     *fLayMenuBar, *fLayMenuItem ; 
  TGLayoutHints     *fLayTab ; 
  
  //     some icons and pictures often used
  
  const TGPicture   *fPicCdup;   //!
  const TGPicture   *fPicList;   //!
  const TGPicture   *fPicDetail; //!
  
 public: 
  MGEventDispMain(const TGWindow *p, const TGWindow *main, UInt_t w, UInt_t h) ;
  
  ~MGEventDispMain(); 
  
  void   CloseWindow()  ; 

  Bool_t InputFileSelected() ; 
  
  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

  ClassDef(MGEventDispMain, 1)

} ; 

#endif


