#ifndef MRAWEVTPIXELITER_H
#define MRAWEVTPIXELITER_H
///////////////////////////////////////////////////////////////////////////////
//
//  MRawEvtPixelIter
//
//  class to iterate over all pixels of one event.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef MAGIC_H
#include "MAGIC.h"
#endif

class MRawEvtData;

class MRawEvtPixelIter
{
private:
    UShort_t fNumHiGainEntry;   //! actual number of entry in fHiGainPixId
    UShort_t fNumLoGainEntry;   //! actual number of entry in fLoGainPixId

    UShort_t *fHiGainId;        //! actual entry of fHiGainPixId
    UShort_t *fLoGainId;        //! actual entry of fLoGainPixId

    Byte_t   *fHiGainPos;       //! pointer to hi-gain samples of actual pixel
    Byte_t   *fLoGainPos;       //! pointer to lo-gain samples of actual pixel

    MRawEvtData *fData;         //! pointer to object which we are iterating

public:
    MRawEvtPixelIter(MRawEvtData *dat) : fData(dat)
    {
        Reset();
    }

    MRawEvtData *Next();

    UShort_t GetPixelId() const
    {
        //
        // return Id of actual pixel
        //
        return *fHiGainId;
    }

    Byte_t *GetHiGainFadcSamples() const
    {
        //
        // return a pointer to the fadc samples of the hi gains
        // WARNING: Don't forget to get the number of valid entries
        //          (GetNumSamples) to know how many entries of the array
        //          belong to the actual pixel
        //
        return fHiGainPos;
    }

    ULong_t GetSumHiGainFadcSamples() const;

    Bool_t IsLoGain() const
    {
        //
        // return kTRUE  the lo gains exist for the actual pixel, else return kFALSE
        //
        return *fHiGainId==*fLoGainId;
    }

    Byte_t *GetLoGainFadcSamples() const
    {
        //
        // return a pointer to the fadc samples of the lo gains if they exist
        // for the actual pixel, else return zero
        //
        return IsLoGain() ? fLoGainPos : NULL;
    }

    ULong_t GetSumLoGainFadcSamples() const;

    void Reset();

    void Draw(Option_t *t="GRAPH");

    ClassDef(MRawEvtPixelIter, 1) // iterates over all pixels of one MRawEvtData object
};

#endif
