////////////////////////////////////////////////////////////////////////
//
//  MParWrite
//
////////////////////////////////////////////////////////////////////////

#include "MParWrite.h"

#include "MParList.h"
#include "MParContainer.h"
#include "MObjBuffer.h"

ClassImp(MParWrite)

MParWrite::MParWrite()
{
}

Bool_t MParWrite::PreProcess (MParList *pList)
{
    //
    // remember the pointer to the parameter list fur further usage
    //
    pParList = pList;

    return kTRUE;
}

Bool_t MParWrite::Process()
{
    //
    //   Write Event
    //

    MParContainer *pCont;

    pParList->Reset();
    while ((pCont=pParList->Next()))
    {
        if (!pCont->IsBuffer())
            continue;

        MObjBuffer *pBuf = (MObjBuffer*)pCont;

        if (pBuf->IsOutput() && pBuf->HasChanged())
            pBuf->PutEvent();
    }

    return kTRUE;
}

