#ifndef MARS_MEnergyEst
#define MARS_MEnergyEst

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MEnergyEst : public MParContainer
{
private:
    Double_t fEnergy; // [GeV] Estimated Energy
    Double_t fImpact; // [cm]  Estimated Impact

public:
    MEnergyEst(const char *name=NULL, const char *title=NULL);

    void SetEnergy(Double_t e) { fEnergy = e; }
    void SetImpact(Double_t i) { fImpact = i; }
    Double_t GetEnergy() const { return fEnergy; }
    Double_t GetImpact() const { return fImpact; }

    void Print(Option_t *o="") const;

    ClassDef(MEnergyEst, 1) // Storage Container for the estimated Energy
};

#endif

