// The aim of this macro is to show the cuts applied to the 
// events that survive the g/h separation cuts + the alpha cut.
// The macro can be modified easily to show other things...

// This program reads a TTree (specified by the user) and 
// stores the array containing the variables specified by 
// the user into pointer to arrays. This is done through 
// the member function TTree::Draw()

// Selection rules (cuts) are allowed. In such case, only 
// the variables of the events that pass the cuts specified are 
// stored into the arrays. 


// It  works with arrays of pointers 
// and plot N quantities in the N pads of the same Canvas.
// single strings that contain
// the quantities to be plotted are used.

// This program is an alternative to another (faster?) more 
// professional way of getting info from a Tree.


// As input, this macro needs a root file that is 
// generated by the SupercutsONOFF programs, which is 
// the root file containing the TTrees with the needed info.

// The user must write

// 1) Name of the root file with the info (Path included!!)

// 2) Name of the output ps file produced by the macro (with path included!!)


gROOT -> Reset();

void SCDynamicalSupercutsApplied()
{




  char* RootFile = {"/.magic/magicserv01/scratch/Daniel/SuperCuts/Mrk421/2004_04_22/4slices_3520_nc/E800_1200_Opt_MC/RootFileDynCuts.root"};

  char* OutputPsFilename = {"/.magic/magicserv01/scratch/Daniel/SuperCuts/Mrk421/2004_04_22/4slices_3520_nc/E800_1200_Opt_MC/DynamicalCutsLengthWidthDistApplied.eps"};
  
  
  char* Xaxis = "log(SIZE/[photons])";
  
  char* YaxisVector[6] = {"LENGTH UP [\\circ]", "LENGTH LOW [\\circ]", 
		       "WIDTH UP [\\circ]", "WIDTH LOW [\\circ]", 
		       "DIST UP [\\circ]", "DIST LOW [\\circ]"}; 

  
  


  
  
 


// Name of the root file that contains the Tree
    char* TreeName = {"SupercutsAppliedTrainONThetaRange0_1570mRad"}; // Name of the Tree that contains the variables that have to plotted
   

    
    const Int_t NQuantitiesToBePlot = 6;

    // Write here the quantities to be plot
    
    TString QuantitiesToBePlot[NQuantitiesToBePlot] = 
    {"SupercutsApplied.LengthUp:log10(ShowerParameters.Size)", 
     "SupercutsApplied.LengthLow:log10(ShowerParameters.Size)", 
     "SupercutsApplied.WidthUp:log10(ShowerParameters.Size)", 
     "SupercutsApplied.WidthLow:log10(ShowerParameters.Size)",
     "SupercutsApplied.DistUp:log10(ShowerParameters.Size)", 
     "SupercutsApplied.DistLow:log10(ShowerParameters.Size)"};


    // Write here the number of rows and columns in the ps file

    const Int_t Nrows = 2;
    const Int_t Ncolumns = 3;

    // Title of Canvas.. not really important...

    TString CanvasTitle = ("Dynamical cuts in Length, Width and Dist");

    // 0 for not using and 1 for using Selection cut
    Int_t UseSelectionCut = 1; 
    // Section rule to be applied in the data to be plotted
    char* SelectionCut = {"(SupercutsApplied.Hadronness < 0.5) && ShowerParameters.Alpha < 12"}; 
    
    

    // Vectors where variables will be stored
    Int_t ArrayDimension[NQuantitiesToBePlot];
    Double_t* VarYArray[NQuantitiesToBePlot];
    Double_t* VarXArray[NQuantitiesToBePlot];


    

    // Vector  of pointers to TFile objects and TTree objects that will be used to retrieve 
    // requested info from root file. 

    TFile* FileVector[NQuantitiesToBePlot];
    TTree* TreeVector[NQuantitiesToBePlot];

    // Vector of pointers to graph objects where quantities will be plot

    TGraph* GraphVector[NQuantitiesToBePlot];


    // Options available for plotting the histo are the following ones:
    // "prof" -->> Profile
    // "goff" -->> No draw variables in TTree::Draw()
    // ""     -->> No special option is set

    char* DrawingOption = {"goff"};


    TString selection = UseSelectionCut ? SelectionCut : NULL;



    // Tree is read and stored in dynamic memory pointed by pointer tree.
    
    //  TFile file (RootFile);
    // TTree* tree = (TTree*) file.Get(TreeName);


  

    // Loop in which arrays are retrieved from root file and 
    // array dimensions (with events surviving the selection)
    // are retrieved too.

    for (Int_t i = 0; i < NQuantitiesToBePlot; i++)
      {


	FileVector[i] = new TFile(RootFile, "READ");

	TreeVector[i] = (TTree*) FileVector[i] -> Get(TreeName);
	
	 // Array dimension of temporal vectors where the variables 
	// that will be plotted are stored can be modify accordingly 
	// with the nnumber of events of the Tree
	
	TreeVector[i] -> SetEstimate(TreeVector[i] -> GetEntries());

	// Requested info is "plotted"

	TreeVector[i]  -> Draw(QuantitiesToBePlot[i].Data(), selection, DrawingOption);

	
	// Let's find out the REAL length of the vectors we want 
	// to get from the tree (Selection rules may have removed some events)
	
	ArrayDimension[i] = TreeVector[i] -> GetSelectedRows();
	
	// Vectors are retrieved

	VarYArray[i] = TreeVector[i] -> GetV1();
	VarXArray[i] = TreeVector[i] -> GetV2();

      }

  
   
    // Silly info is displayed for testing...


   
    for (Int_t i = 0; i < NQuantitiesToBePlot; i++)
      {
	cout << "Events that passed the selection for quantity " 
	     << QuantitiesToBePlot[i] << " : " << ArrayDimension[i] << endl;
      }

   
    // Initialization of the graphs with the info contained in the vectors
    // Kind of default features are set for all graphs


     TAxis* axispointer;
      
     

    for (Int_t i = 0; i < NQuantitiesToBePlot; i++)
      {	
	GraphVector[i] = new TGraph (ArrayDimension[i], VarXArray[i], VarYArray[i]);
	
	GraphVector[i] -> SetTitle(QuantitiesToBePlot[i].Data());

	
	GraphVector[i]->SetFillColor(19);
	GraphVector[i]->SetMarkerColor(2);
	GraphVector[i]->SetMarkerStyle(21);
	GraphVector[i]->SetMarkerSize(0.5);

	axispointer = GraphVector[i] -> GetXaxis();
	axispointer -> SetTitle(Xaxis);
	axispointer -> SetTitleOffset(1.3);
	axispointer -> SetTitleSize(0.05);


	axispointer =  GraphVector[i] -> GetYaxis();
	axispointer -> SetTitle(YaxisVector[i]);
	axispointer -> SetTitleOffset(1.5);
	axispointer -> SetTitleSize(0.05);
	

      }



   
    /*
    // Let's output some of their components:
    
    for ( Int_t i = 0; i < ArrayDimension[]0; i++)
    {
	cout << VarXArray[0][i] << "  " <<  VarYArray[0][i] << endl;

    }
    */

    
    // TCanvas is defined with the NQuantitiesToBePlot Pads where the graphs 
    // will be plotted

    TCanvas* Canvas = new TCanvas(CanvasTitle, CanvasTitle, 600, 800);
    Canvas -> SetBorderMode(0);
    Canvas -> Divide(Nrows, Ncolumns);
    
    
    // gStyle -> SetFrameFillColor(10);
    gStyle -> SetPadLeftMargin (0.15);
    gStyle -> SetPadRightMargin (0.05);
    gStyle -> SetPadTopMargin (0.00);
    gStyle -> SetPadBottomMargin (0.20);
    
    gStyle -> SetOptTitle(0);

    // Graphs are plot in canvas
    
    for (Int_t i = 0; i < NQuantitiesToBePlot; i++)
      {	
	Canvas -> cd(i+1);
	gPad -> SetBorderMode(0);
	gPad->SetGridx();
	gPad->SetGridy(); 
	//gPad -> SetPadTopMargin (0.05);
	//gPad -> SetPadBottomMargin (0.15);
	
	GraphVector[i] -> Draw("AP");
      }
    
    

    Canvas -> SaveAs(OutputPsFilename);


}
    





