#ifndef MARS_MHEnergyEst
#define MARS_MHEnergyEst

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include <TH3.h>
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MMcEvt;
class MEnergyEst;
class MParList;
class MParameterD;
class MHMatrix;

class MHEnergyEst : public MH
{
private:
    MMcEvt      *fMcEvt;  //!
    MEnergyEst  *fEnergy; //!
    MParameterD *fResult; //!

    Int_t     fMap[100]; // FIXME!
    MHMatrix    *fMatrix; //!

    TH3D fHEnergy;
    TH3D fHResolution;
    TH2D fHImpact;

    Double_t fChisq;

    TH1 *MakePlot(TH3 &h, const char *how);
    void UpdatePlot(TH3 &h, const char *how, Bool_t logy=kFALSE);

    Double_t GetVal(Int_t i) const;

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

public:
    MHEnergyEst(const char *name=NULL, const char *title=NULL);

    void InitMapping(MHMatrix *mat);
    void StopMapping();

    void Paint(Option_t *opt="");
    void Draw(Option_t *option="");

    ClassDef(MHEnergyEst, 1) //

};

#endif
