#ifndef MCT1READASCII_H
#define MCT1READASCII_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class MCerPhotEvt;
class MCT1Pedestals;

class MCT1ReadAscii : public MTask
{
private:
    TString        fFileName;    //! the file name of the string
    ifstream      *fIn;          //! the inputfile
    MCerPhotEvt   *fNphot;       //! the data container for all data.
    MCT1Pedestals *fPedest;      //! ct1 pedestals

public:
    MCT1ReadAscii(const char *filename,
                  const char *name=NULL,
                  const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MCT1ReadAscii, 1)	// Reads the CT1 data file
};

#endif

