#include "MGeomCam.h"


#include <math.h>     // floor
#include "TCanvas.h"

#include "MLog.h"
#include "MHexagon.h"

ClassImp(MGeomCam)

MGeomCam::MGeomCam(Int_t type )
{ 
  //    default constructor

  if ( type == 1 ) {
    // set up the Geometry of CT1 
    
    fNbPixels = 127 ; 
    fPixels = new TObjArray ( fNbPixels ) ; 
    
    CreateCT1() ; 
  } 
  else { 
    // set up the standard Geometry MAGIC
    fNbPixels = 577 ; 
    fPixels = new TObjArray ( fNbPixels ) ; 

    CreateMagic() ; 
  } 
} 

void MGeomCam::Draw( Option_t * )
{ 
  TCanvas *can = new TCanvas("can", "Camera Geometry", 4 ) ; 
  
  //   set the range of the canvas
  if ( fNbPixels == 127 )        // case of CT1
    can->Range(-175, -175, 175, 175 ) ; 
  else
    can->Range(-600, -600, 600, 600 ) ; 

  //   draw all pixels
  
  for ( Int_t i=0; i < fNbPixels ; i++ ) {
      MHexagon *el = new MHexagon ( (*this)[i] )    ;

      el->Draw() ;
  } 
  
} 

void MGeomCam::Print(Option_t *)
{ 
  //   Print Information about the Geometry of the camera
  gLog << " Number of Pixels: " << fNbPixels << endl ;

  for ( Int_t i=0; i<fNbPixels; i++ ) { 
    gLog << " Pixel: " << i << "  " ;
    (*this)[i].Print() ;
  } 
} 

Int_t MGeomCam::GetNbPixels ()
{ 
  //   return the Number of pixels in the MCamGeom class
  return fNbPixels ; 

} 


void MGeomCam::CreateMagic()
{ 
  //   fill the geometry class with the coordinates of the MAGIC camera
  gLog << " Create Magic geometry " << endl ;

  //   here define the hardwire things of the magic telescope
  //
  Float_t xtemp[577] = { 
    0.000,   30.000,   15.000,  -15.000,  -30.000,  -15.000,   15.000,   60.000,
   45.000,   30.000,    0.000,  -30.000,  -45.000,  -60.000,  -45.000,  -30.000,
    0.000,   30.000,   45.000,   90.000,   75.000,   60.000,   45.000,   15.000,
  -15.000,  -45.000,  -60.000,  -75.000,  -90.000,  -75.000,  -60.000,  -45.000,
  -15.000,   15.000,   45.000,   60.000,   75.000,  120.000,  105.000,   90.000,
   75.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,  -75.000,  -90.000,
 -105.000, -120.000, -105.000,  -90.000,  -75.000,  -60.000,  -30.000,    0.000,
   30.000,   60.000,   75.000,   90.000,  105.000,  150.000,  135.000,  120.000,
  105.000,   90.000,   75.000,   45.000,   15.000,  -15.000,  -45.000,  -75.000,
  -90.000, -105.000, -120.000, -135.000, -150.000, -135.000, -120.000, -105.000,
  -90.000,  -75.000,  -45.000,  -15.000,   15.000,   45.000,   75.000,   90.000,
  105.000,  120.000,  135.000,  180.000,  165.000,  150.000,  135.000,  120.000,
  105.000,   90.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,  -90.000,
 -105.000, -120.000, -135.000, -150.000, -165.000, -180.000, -165.000, -150.000,
 -135.000, -120.000, -105.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,
   60.000,   90.000,  105.000,  120.000,  135.000,  150.000,  165.000,  210.000,
  195.000,  180.000,  165.000,  150.000,  135.000,  120.000,  105.000,   75.000,
   45.000,   15.000,  -15.000,  -45.000,  -75.000, -105.000, -120.000, -135.000,
 -150.000, -165.000, -180.000, -195.000, -210.000, -195.000, -180.000, -165.000,
 -150.000, -135.000, -120.000, -105.000,  -75.000,  -45.000,  -15.000,   15.000,
   45.000,   75.000,  105.000,  120.000,  135.000,  150.000,  165.000,  180.000,
  195.000,  240.000,  225.000,  210.000,  195.000,  180.000,  165.000,  150.000,
  135.000,  120.000,   90.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,
  -90.000, -120.000, -135.000, -150.000, -165.000, -180.000, -195.000, -210.000,
 -225.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000, -150.000,
 -135.000, -120.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,   60.000,
   90.000,  120.000,  135.000,  150.000,  165.000,  180.000,  195.000,  210.000,
  225.000,  270.000,  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,
  165.000,  150.000,  135.000,  105.000,   75.000,   45.000,   15.000,  -15.000,
  -45.000,  -75.000, -105.000, -135.000, -150.000, -165.000, -180.000, -195.000,
 -210.000, -225.000, -240.000, -255.000, -270.000, -255.000, -240.000, -225.000,
 -210.000, -195.000, -180.000, -165.000, -150.000, -135.000, -105.000,  -75.000,
  -45.000,  -15.000,   15.000,   45.000,   75.000,  105.000,  135.000,  150.000,
  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,  255.000,  300.000,
  285.000,  270.000,  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,
  165.000,  150.000,  120.000,   90.000,   60.000,   30.000,    0.000,  -30.000,
  -60.000,  -90.000, -120.000, -150.000, -165.000, -180.000, -195.000, -210.000,
 -225.000, -240.000, -255.000, -270.000, -285.000, -300.000, -285.000, -270.000,
 -255.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000, -150.000,
 -120.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,   60.000,   90.000,
  120.000,  150.000,  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,
  255.000,  270.000,  285.000,  330.000,  315.000,  300.000,  285.000,  270.000,
  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,  165.000,  135.000,
  105.000,   75.000,   45.000,   15.000,  -15.000,  -45.000,  -75.000, -105.000,
 -135.000, -165.000, -180.000, -195.000, -210.000, -225.000, -240.000, -255.000,
 -270.000, -285.000, -300.000, -315.000, -330.000, -315.000, -300.000, -285.000,
 -270.000, -255.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000,
 -135.000, -105.000,  -75.000,  -45.000,  -15.000,   15.000,   45.000,   75.000,
  105.000,  135.000,  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,
  255.000,  270.000,  285.000,  300.000,  315.000,  360.000,  330.000,  300.000,
  270.000,  240.000,  210.000,  150.000,   90.000,   30.000,  -30.000,  -90.000,
 -150.000, -210.000, -240.000, -270.000, -300.000, -330.000, -360.000, -360.000,
 -330.000, -300.000, -270.000, -240.000, -210.000, -150.000,  -90.000,  -30.000,
   30.000,   90.000,  150.000,  210.000,  240.000,  270.000,  300.000,  330.000,
  360.000,  420.000,  390.000,  360.000,  330.000,  300.000,  270.000,  240.000,
  180.000,  120.000,   60.000,    0.000,  -60.000, -120.000, -180.000, -240.000,
 -270.000, -300.000, -330.000, -360.000, -390.000, -420.000, -420.000, -390.000,
 -360.000, -330.000, -300.000, -270.000, -240.000, -180.000, -120.000,  -60.000,
    0.000,   60.000,  120.000,  180.000,  240.000,  270.000,  300.000,  330.000,
  360.000,  390.000,  420.000,  480.000,  450.000,  420.000,  390.000,  360.000,
  330.000,  300.000,  270.000,  210.000,  150.000,   90.000,   30.000,  -30.000,
  -90.000, -150.000, -210.000, -270.000, -300.000, -330.000, -360.000, -390.000,
 -420.000, -450.000, -480.000, -480.000, -450.000, -420.000, -390.000, -360.000,
 -330.000, -300.000, -270.000, -210.000, -150.000,  -90.000,  -30.000,   30.000,
   90.000,  150.000,  210.000,  270.000,  300.000,  330.000,  360.000,  390.000,
  420.000,  450.000,  480.000,  540.000,  510.000,  480.000,  450.000,  420.000,
  390.000,  360.000,  330.000,  300.000,  240.000,  180.000,  120.000,   60.000,
    0.000,  -60.000, -120.000, -180.000, -240.000, -300.000, -330.000, -360.000,
 -390.000, -420.000, -450.000, -480.000, -510.000, -540.000, -540.000, -510.000,
 -480.000, -450.000, -420.000, -390.000, -360.000, -330.000, -300.000, -240.000,
 -180.000, -120.000,  -60.000,    0.000,   60.000,  120.000,  180.000,  240.000,
  300.000,  330.000,  360.000,  390.000,  420.000,  450.000,  480.000,  510.000,
  540.000 
  } ; 

  Float_t ytemp[577] = { 
    0.000,    0.000,   25.981,   25.981,    0.000,  -25.981,  -25.981,    0.000,
   25.981,   51.961,   51.961,   51.961,   25.981,    0.000,  -25.981,  -51.961,
  -51.961,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,   77.942,
   77.942,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
  -77.942,  -77.942,  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,
   77.942,  103.923,  103.923,  103.923,  103.923,  103.923,   77.942,   51.961,
   25.981,    0.000,  -25.981,  -51.961,  -77.942, -103.923, -103.923, -103.923,
 -103.923, -103.923,  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,
   77.942,  103.923,  129.904,  129.904,  129.904,  129.904,  129.904,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -129.904, -129.904, -129.904, -129.904, -129.904, -103.923,
  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,
  129.904,  155.885,  155.885,  155.885,  155.885,  155.885,  155.885,  155.885,
  129.904,  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,
  -77.942, -103.923, -129.904, -155.885, -155.885, -155.885, -155.885, -155.885,
 -155.885, -155.885, -129.904, -103.923,  -77.942,  -51.961,  -25.981,    0.000,
   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,  181.865,  181.865,
  181.865,  181.865,  181.865,  181.865,  181.865,  181.865,  155.885,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -155.885, -181.865, -181.865, -181.865, -181.865, -181.865,
 -181.865, -181.865, -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,
  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,
  181.865,  207.846,  207.846,  207.846,  207.846,  207.846,  207.846,  207.846,
  207.846,  207.846,  181.865,  155.885,  129.904,  103.923,   77.942,   51.961,
   25.981,    0.000,  -25.981,  -51.961,  -77.942, -103.923, -129.904, -155.885,
 -181.865, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846,
 -207.846, -207.846, -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,
  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,
  181.865,  207.846,  233.827,  233.827,  233.827,  233.827,  233.827,  233.827,
  233.827,  233.827,  233.827,  233.827,  207.846,  181.865,  155.885,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -233.827, -233.827,
 -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -207.846,
 -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,  -25.981,    0.000,
   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,  181.865,  207.846,
  233.827,  259.808,  259.808,  259.808,  259.808,  259.808,  259.808,  259.808,
  259.808,  259.808,  259.808,  259.808,  233.827,  207.846,  181.865,  155.885,
  129.904,  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,
  -77.942, -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808,
 -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808,
 -259.808, -259.808, -233.827, -207.846, -181.865, -155.885, -129.904, -103.923,
  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,
  129.904,  155.885,  181.865,  207.846,  233.827,  259.808,  285.788,  285.788,
  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,
  285.788,  285.788,  259.808,  233.827,  207.846,  181.865,  155.885,  129.904,
  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
 -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788,
 -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788,
 -285.788, -285.788, -285.788, -259.808, -233.827, -207.846, -181.865, -155.885,
 -129.904, -103.923,  -77.942,  -51.961,  -25.981,   34.641,   86.603,  138.564,
  190.526,  242.487,  294.449,  329.090,  329.090,  329.090,  329.090,  329.090,
  329.090,  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,
  -86.603, -138.564, -190.526, -242.487, -294.449, -329.090, -329.090, -329.090,
 -329.090, -329.090, -329.090, -294.449, -242.487, -190.526, -138.564,  -86.603,
  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,  294.449,  346.410,
  381.051,  381.051,  381.051,  381.051,  381.051,  381.051,  381.051,  346.410,
  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,  -86.603,
 -138.564, -190.526, -242.487, -294.449, -346.410, -381.051, -381.051, -381.051,
 -381.051, -381.051, -381.051, -381.051, -346.410, -294.449, -242.487, -190.526,
 -138.564,  -86.603,  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,
  294.449,  346.410,  398.372,  433.013,  433.013,  433.013,  433.013,  433.013,
  433.013,  433.013,  433.013,  398.372,  346.410,  294.449,  242.487,  190.526,
  138.564,   86.603,   34.641,  -34.641,  -86.603, -138.564, -190.526, -242.487,
 -294.449, -346.410, -398.372, -433.013, -433.013, -433.013, -433.013, -433.013,
 -433.013, -433.013, -433.013, -398.372, -346.410, -294.449, -242.487, -190.526,
 -138.564,  -86.603,  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,
  294.449,  346.410,  398.372,  450.333,  484.974,  484.974,  484.974,  484.974,
  484.974,  484.974,  484.974,  484.974,  484.974,  450.333,  398.372,  346.410,
  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,  -86.603,
 -138.564, -190.526, -242.487, -294.449, -346.410, -398.372, -450.333, -484.974,
 -484.974, -484.974, -484.974, -484.974, -484.974, -484.974, -484.974, -484.974,
 -450.333, -398.372, -346.410, -294.449, -242.487, -190.526, -138.564,  -86.603,
 -34.641
  } ; 

  Float_t rtemp[577] = { 
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
    30.00,30.00,30.00,30.00,30.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
    60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,  
    60.00  } ; 
  
  //   fill the pixels list with this data
  
  for ( Int_t i = 0 ; i< fNbPixels ; i++ ) {     
    fPixels->Add( new MGeomPix(xtemp[i], ytemp[i], rtemp[i]) ) ;
  }   
} 

void MGeomCam::CreateCT1()
{
    //
    // fill the geometry class with the coordinates of the CT1 camera
    //
    gLog << " Create CT1 geometry " << endl ;

    //
    // this algorithm is from Martin Kestel originally
    // it was punt into a root/C++ context by Harald Kornmayer and Thomas Bretz
   
    const Float_t pixdiameter = 21 ;    // units are cm

    //
    //  add the first pixel to the list
    //
    fPixels->Add( new MGeomPix( 0, 0, pixdiameter ) ) ;

    const Float_t kS32  = sqrt(3)/2;
    const Float_t kPI23 = kPI*2/3;

    for (Int_t ringcounter=1; ringcounter<7; ringcounter++) {
        //
        // calc. numofpix in ring number i first
        //
        const Int_t numpixthisring = ringcounter*6;

        //
        // calc. coords for this ring counting from the
        // starting number to the ending number
        //
        for (Int_t ipix = 0; ipix < numpixthisring; ipix++) {

            Float_t ang     = 60.0/ringcounter * ipix;
            Float_t fracang = ang - 60*(int)floor(ang/60);

            ang     /= kRad2Deg;
            fracang /= kRad2Deg;

            Float_t rad  = pixdiameter * ringcounter;
                    rad *= sin(kPI23-fracang) * kS32;

            //   fill the ObjArray with the pixels data ;

            fPixels->Add( new MGeomPix(rad * cos(ang),
                                       rad * sin(ang),
                                       pixdiameter ) ) ;
        }
    }
}

