#include "MFillAdcSpect.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"
#include "MHistosAdc.h"
#include "MRawEvtData.h"
#include "MRawEvtPixelIter.h"

ClassImp(MFillAdcSpect)

    MFillAdcSpect::MFillAdcSpect (const char *name, const char *title) : fRawEvtData(NULL)
{
  *fName  = name  ? name  : "MFillAdcSpect";
  *fTitle = title ? title : "Task to fill the adc spectra with  raw data";
}

Bool_t MFillAdcSpect::PreProcess (MParList *pList)
{
  // connect the raw data with this task
  
  fHistos = (MHistosAdc*)pList->FindCreateObj("MHistosAdc");
  if (!fHistos)
      return kFALSE;

  fRawEvtData = (MRawEvtData*)pList->FindCreateObj("MRawEvtData");
  if (!fRawEvtData)
  {
      *fLog << dbginf << " Error: MRawEvtData not found... exit." << endl;
      return kFALSE ;
  }

  return kTRUE ; 

} 

Bool_t MFillAdcSpect::Process()
{
  //  loop over the pixels and fill the values in the histograms
  
  MRawEvtPixelIter pixel(fRawEvtData);

  const Int_t nhisamples = fRawEvtData->GetNumHiGainSamples() ;
  const Int_t nlosamples = fRawEvtData->GetNumLoGainSamples() ;

  //  cout << "HighSamples " << iHighSamples ;

  while ( pixel.Next() )
    { 
      for (Int_t i=0 ; i<nhisamples ; i++ )
	{ 
	  fHistos->FillAdcHistHi ( pixel.GetPixelId(),
                                   pixel.GetHiGainFadcSamples()[i] );
	}

      for (Int_t i=0 ; i<nlosamples ; i++ )
	{ 
	  fHistos->FillAdcHistLo ( pixel.GetPixelId(),
				   pixel.GetLoGainFadcSamples()[i] );
	}
    } 
  
  return kTRUE;
  
} 
