/***************************************************************************
                          videospot.cpp  -  description
                             -------------------
    begin                : Thu Aug 28 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "videospot.h"
#include "stdlib.h"
#include "math.h"

VideoSpot::VideoSpot()
{
	m_iNumPixel = 0;
	m_iXSum = 0;
	m_iYSum = 0;
	m_iWSum = 0;
}

VideoSpot::VideoSpot( double p_dX, double p_dY, int p_iNumPixel )
{
	m_iNumPixel = p_iNumPixel;
	m_iXSum = (int) rint(p_dX * 100.);
	m_iYSum = (int) rint(p_dY * 100.);
	m_iWSum = 100;
}

VideoSpot::VideoSpot( const VideoSpot& p_Spot )
{
	m_iNumPixel = p_Spot.m_iNumPixel;
	m_iXSum = p_Spot.m_iXSum;
	m_iYSum = p_Spot.m_iYSum;
	m_iWSum = p_Spot.m_iWSum;
}

VideoSpot& VideoSpot::operator=( const VideoSpot& p_Spot )
{
  if (this == &p_Spot) return *this;   // Gracefully handle self assignment

	this->m_iNumPixel = p_Spot.m_iNumPixel;
	this->m_iXSum = p_Spot.m_iXSum;
	this->m_iYSum = p_Spot.m_iYSum;
	this->m_iWSum = p_Spot.m_iWSum;
	return *this;
}

VideoSpot::~VideoSpot()
{
}

/** No descriptions */
bool VideoSpot::contains( int p_iX, int p_iY )
{
	if( ( fabs( p_iX - getX() ) < 10. )
			&&
			( fabs( p_iY - getY() ) < 10. ) )
		return true;
	else
		return false;
}

/** No descriptions */
bool VideoSpot::contains2( int p_iX, int p_iY )
{
	if( ( fabs( p_iX - getX() ) < 25. )
			&&
			( fabs( p_iY - getY() ) < 25. ) )
		return true;
	else
		return false;
}

/** No descriptions */
void VideoSpot::append( int p_iX, int p_iY, int p_iWeight )
{
	m_iXSum += p_iX * p_iWeight;
	m_iYSum += p_iY * p_iWeight;
	m_iWSum += p_iWeight;
	m_iNumPixel++;
}

/** No descriptions */
double VideoSpot::getX()
{
	return ( (double) m_iXSum / (double) m_iWSum );
}

/** No descriptions */
double VideoSpot::getY()
{
	return ( (double) m_iYSum / (double) m_iWSum );
}
/** No descriptions */
bool VideoSpot::isValid()
{
	return ( m_iNumPixel >= 3 );
}
