#ifndef MARS_MHCalibrationHiLoCam
#define MARS_MHCalibrationHiLoCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef MARS_MArrayI
#include "MArrayI.h"
#endif

#ifndef MARS_MArrayD
#include "MArrayD.h"
#endif

class TH1F;

class MGeomCam;
class MArrivalTimeCam;
class MHCalibrationHiLoCam : public MHCalibrationCam
{

private:

  static const Int_t   fgNbins;                      //! Default number of bins        (now set to: 900   )
  static const Axis_t  fgFirst;                      //! Default lower histogram limit (now set to: -13.5 )
  static const Axis_t  fgLast;                       //! Default upper histogram limit (now set to:  13.5 )
  static const Float_t fgProbLimit;                  //! The default for fProbLimit    (now set to: 0.0)  
  
  static const TString gsHistName;                   //! Default Histogram names
  static const TString gsHistTitle;                  //! Default Histogram titles
  static const TString gsHistXTitle;                 //! Default Histogram x-axis titles
  static const TString gsHistYTitle;                 //! Default Histogram y-axis titles

  MArrayD fSumareahi  ;                               //
  MArrayD fSumsectorhi;                               //
  MArrayI fNumareahi  ;                               //
  MArrayI fNumsectorhi;                               //
  MArrayD fSumarealo  ;                               //
  MArrayD fSumsectorlo;                               //
  MArrayI fNumarealo  ;                               //
  MArrayI fNumsectorlo;                               //

  MArrivalTimeCam *fArrTimes;                         //! Pointer to arrival times

  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();

  void   CheckOverflow( MHCalibrationPix &pix);
  
public:

  MHCalibrationHiLoCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationHiLoCam() {}

  // Clone
  TObject *Clone(const char *name="") const;

  // Draw
  void   Draw(const Option_t *opt);       // *MENU*

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  ClassDef(MHCalibrationHiLoCam, 1)	// Histogram class for High Gain vs. Low Gain Calibration
};

#endif
