#ifndef MARS_MRFEnergyEst
#define MARS_MRFEnergyEst

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MHMatrix;
class MDataArray;
class MEnergyEst;

class MRFEnergyEst : public MTask
{
private:
    Int_t fNumTrees;
    Int_t fNumTry;
    Int_t fNdSize;

    TString fRFfileName;
    MHMatrix *fMatrixTrain;
    MHMatrix *fMatrixTest;
    TArrayD fEnergyGrid;

    MDataArray  *fData;       //! Used to store the MDataChains to get the event values
    TObjArray fEForests;

    MEnergyEst *fEnergyEst;

    Int_t PreProcess(MParList *plist);
    Int_t Process();
    Int_t PostProcess();

    Int_t ReadForests(MParList *plist=NULL);

public:
    MRFEnergyEst(const char *name=NULL, const char *title=NULL);
    ~MRFEnergyEst();

    void SetMatrixTrain(MHMatrix *mat) { fMatrixTrain = mat; }
    void SetMatrixTest( MHMatrix *mat) { fMatrixTest  = mat; }
    void SetFile(TString str) { fRFfileName = str; }

    void SetLogEnergyGrid(TArrayD &egrid) { fEnergyGrid = egrid ; }

    void SetNumTrees(UShort_t n=100) { fNumTrees = n; }
    void SetNdSize(UShort_t n=1)     { fNdSize   = n; }
    void SetNumTry(UShort_t n)       { fNumTry   = n; }

    Int_t Train();
    Int_t Test();

    ClassDef(MRFEnergyEst, 0) // Task
};

#endif
