/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!              Benjamin Riegel, 01/2005 <mailto:riegel@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MReportStarguider
//
// This is the class interpreting and storing the STARG-REPORT information.
//
// This is the place to get the azimuth-/zenith mispointing of the telescope
// given by the starguider-camera.
//
//
//
// Double_t fDevAz;          // [deg]   azimuth mispointing
// Double_t fDevZd;          // [deg]   zenith  mispointing
//
//
//////////////////////////////////////////////////////////////////////////////
#include "MReportStarguider.h"

#include "MLogManip.h"

ClassImp(MReportStarguider);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. Initialize identifier to "STARG-REPORT"
//
MReportStarguider::MReportStarguider() : MReport("STARG-REPORT"),
    fDevAz(0), fDevZd(0)
{
    fName  = "MReportStarguider";
    fTitle = "Class for STARG-REPORT information (telescope mispointing)";
}

// --------------------------------------------------------------------------
//
// Interprete the body of the STARG-REPORT string
//
Int_t MReportStarguider::InterpreteBody(TString &str, Int_t ver)
{
    Int_t len;
    Int_t n=sscanf(str.Data(), "%lf %lf %n", &fDevAz, &fDevZd, &len);
    if (n!=2)
    {
        *fLog << warn << "WARNING - Not enough arguments." << endl;
        return kCONTINUE;
    }

    str.Remove(0, len);

     str = str.Strip(TString::kBoth);

    return str.IsNull() ? kTRUE : kCONTINUE;
}


void MReportStarguider::Print(Option_t *o) const
{
    *fLog << GetDescriptor() << ": DevZd=" << fDevZd << " DevAz=" << fDevAz << endl;
}
