/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Sebastian Raducci, 12/2003 <mailto:raducci@fisica.uniud.it>
!   Author(s): Markus Gaug        04/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MArrivalTime
//
// Times are calculated using the TSpline5 Root Class
// 
/////////////////////////////////////////////////////////////////////////////
#include "MArrivalTime.h"

#include "MGeomCam.h"
#include "MGeomPix.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MRawEvtPixelIter.h"
#include "MRawEvtData.h"

ClassImp(MArrivalTime);

using namespace std;


// --------------------------------------------------------------------------
//
// Creates an object containing the arrival time for each pixel in the event
//
MArrivalTime::MArrivalTime(const char *name, const char *title)
{
    fName  = name  ? name  : "MArrivalTime";
    fTitle = title ? title : "Photons arrival times Information";
}

// -------------------------------------------------------------------------
//
// Sets every pixel arrival time to -1
//
void MArrivalTime::Reset()
{
    fData.Reset(-1);
}

void MArrivalTime::InitSize(const UInt_t i)
{
    fData.Set(i);
}

// -------------------------------------------------------------------------
// 
// Set the arrival time in one pixel
//
void MArrivalTime::SetTime(const Int_t i, const Float_t t)
{
    fData[i] = t;
}
      

void MArrivalTime::Print(Option_t *o) const
{
    *fLog << all << GetDescriptor() << ":" << endl;
    for (int i=0; i<fData.GetSize(); i++)
      *fLog << Form("Pixel %04d:  Arr.Time: %4.3f",i,fData[i]) << endl;
    *fLog << endl;
}

// --------------------------------------------------------------------------
//
// Returns the arrival time value
//
Bool_t MArrivalTime::GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type) const
{
    if (idx<0 || idx>=fData.GetSize())
        return kFALSE;

    switch (type)
    {
    case 0:
        val = fData[idx];
        break;
    default:
        return kFALSE;
    }

    return val>=0;
}

void MArrivalTime::DrawPixelContent(Int_t num) const
{
    *fLog << warn << "MArrivalTime::DrawPixelContent - not available." << endl;
}
