#ifndef MARS_MDirIterExt
#define MARS_MDataSetIter

#ifndef MARS_MDirIter
#include "MDirIter.h"
#endif

#ifndef MARS_MRunIter
#include "MRunIter.h"
#endif

#ifndef MARS_MSequence
#include "MSequence.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MLog;
class TString;

class MDataSetIter : public MDirIter
{
 private:
    
    TObjArray fFileList;  // List with all the file names ordered by name
                          // The list contains TNamed(file, "")
    TObjArray fSrcList;   // List with the valid source names

   
    Int_t fInitialRun;  // Runnumber of the first run to proccess
    Int_t fEndRun;      // Runnumber of the last run to proccess
    Int_t fLastProcessedDataRun;  // Runnumber of the last processed run
    Int_t fLastDataRun; // Lst Data runnumber in fFileList

    MRunIter* fPedRuns;
    MRunIter* fCalRuns;
    MRunIter* fDataRuns;
    MSequence* fSequence;

    TString fSrcName;
    TString fDate;

    Int_t fDefCalRun;
    TString fDefCalRunPath;  

    MLog *fLog;
    
   
    Int_t CheckSourceName(TString& src);
    Int_t CompareSourceNames(TString& src1, TString& src2);
    void  AddToFileList(MDirIter& dir);
    void  ScanFileName(const TString& file, TString& name, TString& path, TString& date, TString& src, Int_t* run, char* type);  
    Int_t IsPreviousRunUsable(MRunIter& oldRun);
    Int_t Loop(TString option, TString LockSrcName="");
    void FindLastDataRun();

 public:
    
    MDataSetIter();
 
    Int_t AddDirectory(const char *dir, const char *filter="*.root", Int_t recursive=0);    
    void SelectSourceName(const char *src);
   
    Int_t NextDataSet(); 

    void SetInitialRun(Int_t run) { fInitialRun = run; }
    void SetEndRun(Int_t run) 
    { 
	fEndRun = run; 
	FindLastDataRun();
    } 
    void SetDefCalRun(Int_t run, const char* path) {fDefCalRun = run; fDefCalRunPath = path; }

    Int_t GetLastProcessedRun() const { return fLastProcessedDataRun; }

    TString*  GetSrcName()  { return &fSrcName; }
    TString*  GetDate()     { return &fDate;    }
    MRunIter* GetDataRuns() 
    { 
	fDataRuns->Reset(); 
	return fDataRuns;     
    }
    MRunIter* GetPedRuns()  
    {
	fPedRuns->Reset();
	return fPedRuns;     
    }
    MRunIter* GetCalRuns()  
    {
	fCalRuns->Reset();
	return fCalRuns;
    }
    
    void Reset()
    {
	fLastProcessedDataRun = 0; 
    }

    void Print(const Option_t *option="") const;
    
    Bool_t HasFinishedSuccesfully();

    Int_t WriteSequence();


    ClassDef(MDataSetIter, 1) // Iterator for data set made of Pec, Cal and Data runs
};

#endif
