//**************************************************************************************************************
//
// Sample A ON  = Runs 17206 - 17265
// Sample A OFF = Runs 17269 - 17283
//
// Sample B ON  = Runs 17286 - 17456
// Sample B OFF = Runs 17459 - 17543
//
//**************************************************************************************************************

//**************************************************************************************************************
// general INPUT
//**************************************************************************************************************

// pi
const double  PI=3.14159265358979333;  //atan(1)*4.0

// conversion from deg to mm and vice versa
const Double_t mm2deg = 180./17000./PI;
const Double_t deg2mm = 1./mm2deg;

// conversion from rad to deg and vice versa
const Double_t rad2deg = 180./PI;
const Double_t deg2rad = 1./rad2deg;

// conversion from millisec to min
const Double_t msec2min=1./1000./60.;

//--------------------------------------------------------------------------------------------------------------
// main path

// HUB
TString inpath = "/users/eeh/hengsteb/MAGIC/Mkn421Feb2004/SlidingWindow/";
TString path = "/users/eeh/hengsteb/MAGIC/Mkn421Feb2004/";

// laptop
//TString inpath = "/home/hengsteb/MAGIC/Mkn421Feb2004/";
//TString path = "/home/hengsteb/MAGIC/Mkn421Feb2004/";

//**************************************************************************************************************
// INPUT/OUTPUT for MagicHillas.C, ScaleHillas.C, SrcCorrect.C, FSrcPlot.C
//**************************************************************************************************************

//--------------------------------------------------------------------------------------------------------------
// Mkn421 ON A
TString dataOnA="SLIDINGRun17206-17265CalibRun17193_D_Mkn421On_E";

//--------------------------------------------------------------------------------------------------------------
// Mkn421 OFF A
TString dataOffA="SLIDINGRun17269-17283CalibRun17268_D_OffMkn421_E";

//--------------------------------------------------------------------------------------------------------------
// Mkn421 ON B
TString dataOnB="SLIDINGRun17286-17456CalibRun17285_D_Mkn421On_E";

//--------------------------------------------------------------------------------------------------------------
// Mkn421 OFF B
TString dataOffB="SLIDINGRun17459-17543CalibRun17458_D_OffMkn421_E";

//--------------------------------------------------------------------------------------------------------------
// select the sample!
TString data=dataOnB;

TString fileCalibData =  inpath + data + ".root";
TString fileHillas    =  path + data + "_Hillas.root";
TString fileHScaled   =  path + data + "_HScaled.root";
TString fileHScalHist =  path + data + "_HScalHist.root";

TString fileFSrcPlot  =  path + data + "_FSrcPlot.root";
TString fileSrcPos    =  path + data + "_SrcPos.dat";

TString fileFSrcPlotC =  path + data + "_FSrcPlotC.root"; //corrected with known src pos
TString fileHScaledC  =  path + data + "_HScaledC.root";  //corrected with known src pos

//--------------------------------------------------------------------------------------------------------------
// dead pixels

const Int_t NDEAD=54;
const Short_t DEADPIX[NDEAD]=
{  0,  25,  26,  34,  38,  46,  54, 124, 125, 155, 156, 157, 158, 162, 170, 172, 201, 202, 203, 204, 205,
 206, 207, 208, 224, 388, 395 ,397, 440, 441, 442, 443, 444, 445, 446, 483, 484, 485, 486, 487, 488, 489,
 490, 532, 533, 534, 535, 536, 537, 538, 539, 540, 543, 559 };
// 1    2    3    4    5    6    7    8    9   10   11   12   13   14   15   16   17   18   19   20   21

TArrayS blindpix(NDEAD,DEADPIX);

//--------------------------------------------------------------------------------------------------------------
// default cuts for false source plots
/*
//Double_t SizeLo   = 1000.; // #ph
//Double_t SizeLo   = 1111.; // #ph
Double_t SizeLo   = 2000.; // #ph
Double_t DistLo   = 0.6;   // degree
Double_t DistUp   = 1.4;   // degree

// static cuts
//Double_t LengthLo = 0.14*deg2mm;  // degree
//Double_t LengthUp = 0.26*deg2mm;  // degree
//Double_t WidthLo  = 0.05*deg2mm;  // degree
//Double_t WidthUp  = 0.14*deg2mm;  // degree

// scaled Hillas

Double_t LengthLo = 0.2525;
Double_t LengthUp = 0.9312;
Double_t WidthLo  = 0.2875;
Double_t WidthUp  = 0.738;
//*/

//**************************************************************************************************************
// INPUT/OUTPUT for AlphaPlot.C, CutOptim.C
//**************************************************************************************************************

//--------------------------------------------------------------------------------------------------------------
// Mkn421 A + B

// AlphaPlot + LightCurve, CutOptim
TString fileOn1      = path + dataOnA + "_HScaledC.root";
TString fileOn2      = path + dataOnB + "_HScaledC.root";

TString fileOff1     = path + dataOffA + "_HScaled.root";
TString fileOff2     = path + dataOffB + "_HScaled.root";

TString fileRateCFac = path + "Mkn421A+B_CFac.dat";
TString fileLCurve   = path + "Mkn421A+B_LCurve.dat";
TString fileAPlots   = path + "Mkn421A+B_APlot.root";

// matrices needed for cut optimization, optimize on sample A
TString fileOptOn    = path + dataOnA  + "_HScaledC.root";
TString fileOptOff   = path + dataOffA + "_HScaled.root";

TString fileMatOn    = path + dataOnA  + "_Matrix.root";
TString fileMatOff   = path + dataOffA + "_Matrix.root";

//--------------------------------------------------------------------------------------------------------------
// optimized cuts for 1-dim aplot

//Double_t SizeLo   = 1111.; // #ph
Double_t SizeLo   = 2000.; // #ph
Double_t DistLo   = 0.55;
Double_t DistUp   = 1.27;
//Double_t DistLo   = 1.;
//Double_t DistUp   = 1.5;
//Double_t DistLo   = 0.5;
//Double_t DistUp   = 1.22;

// optimized on half of sample A for scaled Hillas with dist-cut 0.6 - 1.25, size > 1300
Double_t LengthLo = 0.318;
Double_t LengthUp = 0.809;
Double_t WidthLo  = 0.3;
Double_t WidthUp  = 0.705;
//*/
