#ifndef MARS_MApplySupercuts
#define MARS_MApplySupercuts

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MHadronness
#include "MHadronness.h"
#endif

class MGeomCamMagic;
class MParList;
class MRawEvtHeader;
class MRawRunHeader;
class MSupercuts;
class MHillas;
class MHillasSrc;
class MHadronness;
class MHFindSignificance;
class MEnergyEst;
class TH1F;

class MApplySupercuts : public MTask
{
 private:

  // Constant to convert size in photoelectrons to photons
  static const Float_t kPhe2Ph = 0.18;
  static const Double_t kHadronHadronness = 0.75;
  static const Double_t kGammaHadronness = 0.25;
  static const Double_t fDistOffset = 0.9;
  static const Double_t fSizeOffset = 3000.;

  Bool_t fPhe;
  Bool_t fPlot;
  Double_t fLengthUp[8];
  Double_t fLengthLo[8];
  Double_t fWidthUp[8];
  Double_t fWidthLo[8];
  Double_t fDistUp[8];
  Double_t fDistLo[8];
  Double_t fAlphaMin;    // Minimum alpha of background region (deg)
  Double_t fAlphaMax;    // Maximum alpha of background region (deg)
  Double_t fAlphaSignal; // Maximum alpha of signal region (deg - Min=0)
  Int_t fDegree;         // Degree of polinomial interpolating function
  Double_t fSizeUp;
  Double_t fSizeLow;

  TString fSCFilename;
  
  MGeomCamMagic   *fGeom;
  MRawRunHeader   *fRunHeader;
  MRawEvtHeader   *fEvtHeader;
  MSupercuts      *fSupercuts;
  MHillas         *fHillas;
  MHillasSrc      *fHillasSrc;

  TH1F            *fAlpha;
  MHadronness     *fHadronness;
  MHFindSignificance *fHFindSigma;
  MEnergyEst      *fEnergyEst;

  Double_t CalcLimit(Double_t *a, Double_t ls, Double_t ls2, Double_t dd2);

  Int_t PreProcess(MParList *pList);
  Int_t Process();
  Int_t PostProcess();
  
 public:
  MApplySupercuts(const char *name=0, const char *title=0);

  void SetPhotoelectrons() { fPhe = kTRUE; }
  void SetPhotons() { fPhe = kFALSE; }
  void SetSCFilename(TString filename) { fSCFilename = filename; }
  void SetPrintOutSignificance(Double_t bgalphamin, Double_t bgalphamax, 
			       Double_t alphasig, Int_t kDegree);
  void SetPlotON() { fPlot = kTRUE; };
  void SetPlotOFF() { fPlot = kFALSE; };
  void SetBGAlphaMin(Double_t alphamin) { fAlphaMin=alphamin; SetPlotON(); };
  void SetBGAlphaMax(Double_t alphamax) { fAlphaMax=alphamax; SetPlotON(); };
  void SetAlphaSig(Double_t alphasig) { fAlphaSignal=alphasig; SetPlotON(); };
  void SetPolDegree(Int_t deg) { fDegree=deg; SetPlotON(); };
  void SetPlotSizeLow(Double_t size) { fSizeLow = size; };
  void SetPlotSizeUp(Double_t size) { fSizeUp = size; };

  ClassDef(MApplySupercuts, 1) // Task to apply supercuts
};
    
#endif
    
