#ifndef MARS_MHMuonPar
#define MARS_MHMuonPar

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TProfile
#include <TProfile.h>
#endif

class MMuonSearchPar;
class MMuonCalibPar;
class MGeomCam;

class MHMuonPar : public MH
{
private:
    TH1F     fHistRadius;    //
    TH1F     fHistArcWidth;  //

    TProfile fHistBroad;     // Area of used pixels
    TProfile fHistSize;      // [ratio] concentration ratio: sum of the two highest pixels / fSize

    MMuonSearchPar *fMuonSearchPar; //!
    MMuonCalibPar  *fMuonCalibPar;  //!

    Float_t fMm2Deg;

public:
    MHMuonPar(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    //TH1 *GetHistByName(const TString name);

    const TH1F&     GetHistRadius() const    { return fHistRadius; }
    const TH1F&     GetHistArcWidth() const  { return fHistArcWidth; }
    const TProfile& GetHistBroad() const     { return fHistBroad; }
    const TProfile& GetHistSize() const      { return fHistSize; }

    void Draw(Option_t *opt="");

    ClassDef(MHMuonPar, 1) // Histograms of new image parameters
};

#endif


