#ifndef MARS_MCalibColorSteer
#define MARS_MCalibColorSteer

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif


class MParList;
class MGeomCam;
class MCalibrationPattern;
class MRawRunHeader;
class MCalibrationChargeCalc;
class MCalibrationRelTimeCalc;
class MCalibrationIntensityChargeCam;
class MCalibrationIntensityBlindCam;
class MCalibrationIntensityQECam;
class MCalibrationIntensityRelTimeCam;
class MBadPixelsIntensityCam;
class MBadPixelsCam;

class MCalibColorSteer : public MTask
{
private:


  MCalibrationPattern             *fCalibPattern;    //!
  MRawRunHeader                   *fRunHeader;       //!
  MGeomCam                        *fGeom;            //!
  MParList                        *fParList;         //!
  MCalibrationIntensityChargeCam  *fIntensCharge;    //!
  MCalibrationIntensityBlindCam   *fIntensBlind;     //!  
  MCalibrationIntensityQECam      *fIntensQE;        //!
  MCalibrationIntensityRelTimeCam *fIntensRelTime;   //!
  MBadPixelsIntensityCam          *fIntensBad;       //!
  MBadPixelsCam                   *fBad;             //!
  
  MCalibrationChargeCalc          *fChargeCalc;      //!
  MCalibrationRelTimeCalc         *fRelTimeCalc;     //!
                                                     
  MCalibrationCam::PulserColor_t   fColor;
  Float_t                          fStrength;
  
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  
  Bool_t ReInitialize();
  Bool_t Finalize(const char* name);
  TString GetNamePattern();
  
public:

    MCalibColorSteer(const char *name=NULL, const char *title=NULL);
    ~MCalibColorSteer() {}

    ClassDef(MCalibColorSteer, 1) // Task to steer the processing of multiple calibration colours
};
    
#endif

