#ifndef MARS_MHMyFindSignificanceONOFF
#define MARS_MHMyFindSignificanceONOFF

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MHFindSignificance
#include "MHFindSignificance.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class TF1;
class TH1;
class TCanvas;

class MHMyFindSignificanceONOFF : public MH
{
 private:
    
    TH1  *fHistOrigON;  // original plot of |alpha| (0.0 to 90.0 degrees)
    TH1  *fHistON;      // copy of fHistOrig or rebinned histogram
    TH1  *fHistOrigOFF;  // original plot of |alpha| (0.0 to 90.0 degrees)
    TH1  *fHistOFF;      // copy of fHistOrig or rebinned histogram
    TH1  *fHistOFFNormalized;   //  fHistOFF normalized (contents and errors) with 
            
    MHFindSignificance fFindsigON; // Will contain the fit of the on data 
    MHFindSignificance fFindsigOFF;
    

    Double_t fAlphasig;
    Double_t fAlphaminON;
    Double_t fAlphamaxON;
    Double_t fAlphaminOFF;
    Double_t fAlphamaxOFF;
    Int_t fDegree;
    
    Double_t fNormFactor;  // Normalization factor between ON and OFF hists.
    Double_t fNormFactorError;

    // Couted quatities
    Double_t fNon; 
    Double_t fdNon;
    Double_t fNbg;        // Counts in the signal region of OFF hist, NO normalized !!!
    Double_t fdNbg;
    Double_t fNex;
    Double_t fdNex;
    Double_t fSigLiMa; // significance of gamma signal according to Li & Ma

    // from the polynomial fit of the OFF data
    Double_t fNbgFit;
    Double_t fdNbgFit;
    Double_t fNexFit;
    Double_t fdNexFit;
    Double_t fGamma;
    Double_t fNoff;
    Double_t fSigLiMaFit; // significance of gamma signal according to Li & Ma

    Bool_t fRebin;         // if true : allow rebinning of the alpha plot    
    Bool_t fReduceDegree;  // if true : allow reducing of the order of the polynomial

    const static Double_t fEps = 1.e-4;  // tolerance for floating point 
                                         // comparisons


    Double_t fBestSigma;
    Double_t fBestAlphaCut;
    Double_t fBestExcess;

    void NormalizedHistOFF();
    void DrawResults(Option_t* option="all");

public:

    MHMyFindSignificanceONOFF(const char *name=NULL, const char *title=NULL);
   
     Bool_t FindSigmaONOFF(TH1 *histON, TH1 *histOFF, Double_t alphasig, Double_t alphamin, Double_t alphamax, Int_t degree);

     Int_t CountEventsInRange(TH1* hist, Double_t alphalo, Double_t alphaup, Double_t* numevents, Double_t* numeventserror);

    Int_t CalcNormalizationFactor(TH1* hon, TH1* hoff, Double_t alphalo, Double_t alphaup);
    
    Bool_t SigmaLiMa(Double_t non, Double_t noff, Double_t gamma,
                     Double_t *siglima);


    Double_t GetNormFactor() const { return fNormFactor; }
    Double_t GetNon()        const { return fNon;             }
    Double_t GetNbg()        const { return fNbg*fNormFactor; } // <------!!!
    Double_t GetNex()        const { return fNex;             } 
    Double_t GetdNex()        const { return fdNex;             } 

    Double_t GetSigLiMa()    const { return fSigLiMa;            }
    Double_t GetNbgFit()     const { return fNbgFit*fNormFactor; } //<------!!!
    Double_t GetNexFit()     const { return fNexFit;             } 
    Double_t GetSigLiMaFit() const { return fSigLiMaFit;         }
   
       
    void SetRebin(Bool_t b=kTRUE);
    void SetReduceDegree(Bool_t b=kTRUE);


    void Draw(Option_t* option="all");
    
    Bool_t SigmaVsAlpha(TH1 *histON, TH1 *histOFF,  Double_t alphamin, Double_t alphamax, Int_t degree, Bool_t draw=kTRUE);



     Double_t GetBestSigma() const {return fBestSigma;}
     Double_t GetBestAlphaCut() const {return fBestAlphaCut;}
     Double_t GetBestExcess() const {return fBestExcess;}

    ClassDef(MHMyFindSignificanceONOFF, 1) // Determine significance from ON and OFF data
};

#endif




















