/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  2/2005 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MEnv
//
// It is a slightly changed version of TEnv. It logs all resources which are
// touched, so that you can print all untouched resources by
// PrintUntouched()
//
//////////////////////////////////////////////////////////////////////////////
#include "MEnv.h"

#include <TObjString.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MEnv);

using namespace std;

Int_t MEnv::GetValue(const char *name, Int_t dflt)
{
    if (!fChecked.FindObject(name))
        fChecked.Add(new TObjString(name));
    return TEnv::GetValue(name, dflt);
}

Double_t MEnv::GetValue(const char *name, Double_t dflt)
{
    if (!fChecked.FindObject(name))
        fChecked.Add(new TObjString(name));
    return TEnv::GetValue(name, dflt);
}

const char *MEnv::GetValue(const char *name, const char *dflt)
{
    if (!fChecked.FindObject(name))
        fChecked.Add(new TObjString(name));
    return TEnv::GetValue(name, dflt);
}

void MEnv::PrintUntouched() const
{
    int i=0;
    gLog << inf << flush;
    gLog.Separator("Untouched Resources");
    TIter Next(GetTable());
    TObject *o=0;
    while ((o=Next()))
        if (!fChecked.FindObject(o->GetName()))
        {
            gLog << warn << " - Resource " << o->GetName() << " not touched" << endl;
            i++;
        }
    if (i==0)
        gLog << inf << "None." << endl;
    else
        gLog << inf << i << " resources have not been touched." << endl;
}
