#ifndef MARS_MMcWeightEnergySpecCalc
#define MARS_MWeigthEnergySlopeCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif


class MParList;
class MMcEvt;
class MParameterD;
class TF1;


class MMcWeightEnergySpecCalc : public MTask
{

 private:

    const MMcEvt *fMcEvt;
    MParameterD  *fWeight;

    TF1*     fNewSpectrum;     // Function with the new spectrum

    Bool_t   fNewSpecIsPowLaw; // Tells whether the new spectrum is introduced 
                               //as a TF1 object or not
    Double_t fCorsikaSlope; // Slope of energy spectrum generated with Corsika
    Double_t fNewSlope;     // Slope of the new spectrum (if it is a power law)
    Double_t fELowLim;      
    Double_t fEUppLim;      // Limits of energy range for generation
    Double_t fCorSpecInt;   // Value of the integrals of the Corsika and new
    Double_t fNewSpecInt;   //spectrum respectively, between fElow and fUppLim

    UInt_t   fTotalNumSimulatedShowers;
    Bool_t   fAllEvtsTriggered;

    void   Init(const char *name, const char *title);
    Bool_t ReInit(MParList *plist); 

    Int_t PreProcess(MParList *pList);
    Int_t Process();
   

 public:

    MMcWeightEnergySpecCalc(const Float_t slope,
			    const char *name=NULL, const char *title=NULL);

    MMcWeightEnergySpecCalc(const TF1& spectrum,
			    const char *name=NULL, const char *title=NULL);

    MMcWeightEnergySpecCalc(const char* spectrum,
			    const char *name=NULL, const char *title=NULL);
   
    MMcWeightEnergySpecCalc(void *function,
			    const char *name=NULL, const char *title=NULL);
 
    MMcWeightEnergySpecCalc(Double_t (*function)(Double_t* x, Double_t* par),
	      const Int_t npar, const char *name=NULL, const char *title=NULL);
    

    ~MMcWeightEnergySpecCalc();


    ClassDef(MMcWeightEnergySpecCalc, 0) // Task to convert the spectrum of the MC showers simulated with Corsika to a different one, by using weights
};

#endif 








