#ifndef MARS_MHMuonPar
#define MARS_MHMuonPar

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TProfile
#include <TProfile.h>
#endif

class MMuonSearchPar;
class MMuonCalibPar;
class MGeomCam;

class MHMuonPar : public MH
{
private:
    TH1F     fHistRadius;    // Radius
    TH1F     fHistArcWidth;  // ArcWidth

    TProfile fHistBroad;     // ArcWidth/Radius Vs Radius
    TProfile fHistSize;      // MuonSize Vs Radius

    MMuonSearchPar *fMuonSearchPar; //!
    MMuonCalibPar  *fMuonCalibPar;  //!

    Float_t fMm2Deg;

public:
    MHMuonPar(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    const TH1F&     GetHistRadius() const    { return fHistRadius; }
    const TH1F&     GetHistArcWidth() const  { return fHistArcWidth; }
    const TProfile& GetHistBroad() const     { return fHistBroad; }
    const TProfile& GetHistSize() const      { return fHistSize; }

    void Draw(Option_t *opt="");
    void Paint(Option_t *opt="");

    ClassDef(MHMuonPar, 1)
};

#endif


