#include <TApplication.h>

#include "MAGIC.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MArgs.h"
#include "MArray.h"
#include "MParContainer.h"

#ifdef HAVE_XPM
#include "MLogo.h"
#endif

#include "MCameraDisplay.h"
#include "MEventDisplay.h"

using namespace std;

// **********************************************************************
//
//    MARS main program  
//
//    The only job of the main program is the initialisation of ROOT and 
//    the start of the guiinterface for the mars program
//
//    started by  h. kornmayer      january, 3rd  2001 
static void StartUpMessage()
{
    gLog << all << endl;

    //                1         2         3         4         5
    //       12345678901234567890123456789012345678901234567890
    gLog << "==================================================" << endl;
    gLog << "                    MARS V" << MARSVER              << endl;
    gLog << "    Magic Analysis and Reconstruction Software"     << endl;
    gLog << "   Compiled with ROOT v" << ROOTVER << " on <" << __DATE__ ">" << endl;
    gLog << "==================================================" << endl;
    gLog << endl;
}

static void Usage()
{
    gLog << all << endl;
    gLog << "Sorry the usage is:" << endl;
    gLog << " mars [options] [filename]" << endl << endl;
    gLog << " Options:" << endl;
    gLog.Usage();
    gLog << "     -?/-h: This help" << endl << endl;
}

int main(int argc, char **argv)
{
    //
    // Evaluate arguments
    //
    MArgs arg(argc, argv, kTRUE);
    gLog.Setup(arg);

    StartUpMessage();

    if (arg.HasOption("-?") || arg.HasOption("-h") || arg.GetNumArguments()>1)
    {
        Usage();
        return 2;
    }

    //
    // This is to make argv[i] more readable insidethe code
    //
    const TString kFilename = arg.GetArgumentStr(0);

#ifdef HAVE_XPM
    MLogo logo;
    logo.Popup();
#endif

    //
    // initialise ROOT
    //
    TApplication app("mars", &argc, argv);
    if (gROOT->IsBatch() || !gClient)
    {
        gLog << "Bombing... maybe your DISPLAY variable is not set correctly!" << endl;
        return 1;
    }

    //
    // Swtich of TObjectStreamer in our base classes derived from TObject
    //
    MArray::Class()->IgnoreTObjectStreamer();
    MParContainer::Class()->IgnoreTObjectStreamer();

#ifdef HAVE_XPM
    logo.Popdown();
#endif

    //
    // start the main window
    //
    if (kFilename.IsNull())
        new MCameraDisplay;
    else
    {
        MEventDisplay *d = new MEventDisplay(kFilename);
        d->SetBit(MStatusDisplay::kExitLoopOnExit);
        d->SetTitle(kFilename);
    }

    //
    // run the application
    //
    app.Run();

    gLog << all << endl;

    return 0;
}
 

