#ifndef MARS_MRanForestCalc
#define MARS_MRanForestCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MHMatrix
#include "MHMatrix.h"
#endif

class MParList;
class MParameterD;
class MDataArray;
class MRanTree;
class MRanForest;

class MRanForestCalc : public MTask
{
private:
    Int_t  fNum;              // number of trees used to compute hadronness

    TString fHadronnessName;  // Name of container storing hadronness

    MParameterD *fHadroness;  //! Output container for calculated hadroness
    MDataArray  *fData;       //! Used to store the MDataChains to get the event values
    MRanForest  *fRanForest;
    MRanTree    *fRanTree;

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    enum { kIsOwner = BIT(14) };

    Bool_t IsOwner() const { return TestBit(kIsOwner); }
    void SetOwner() { SetBit(kIsOwner); }

public:
    MRanForestCalc(const char *name=NULL, const char *title=NULL);
    ~MRanForestCalc();

    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    TString GetHadronnessName() const { return fHadronnessName; }

    void SetUseNumTrees(UShort_t n=100) { fNum = n; }

    Bool_t Grow(MHMatrix *matrixg,MHMatrix *matrixh,Int_t ntree,
                Int_t numtry,Int_t ndsize,const char* treefile=0,
                const char* treename=0,const char* contname=0,
                const char* hgininame=0);

    Bool_t Fill(Int_t ntree,const char* treefile=0,const char* treename=0);


    ClassDef(MRanForestCalc, 0) // Task
};

#endif
