#include "MShowSpect.h"

#include <stdlib.h>

#include <TROOT.h> 
#include <TApplication.h> 
#include <TSystem.h> 
#include <TGClient.h> 
#include <TGFileDialog.h> 
#include <TVirtualX.h>

#include "MRawEvt.h"
#include "MParList.h"
#include "MHistosAdc.h"


////////////////////////////////////////////////////////////////////////
//
//  MGShowSpect.h
//
//  A Gui Task to show the raw ADC values in the histograms
//

ClassImp(MShowSpect)

MShowSpect::MShowSpect(char *nameHist ) 
{ 
  // default constructor 

  sprintf (fHistName, "%s", nameHist ) ; 
} 


Bool_t MShowSpect::PreProcess(MParList *pList)
{
  //
  //   Do the preprocessing for MShowSpect
  // 
  //   Connects Histogramms in the MHistosAdc container as the input
  //

  fHists = (MHistosAdc*) pList->FindObject( fHistName );
  
  if (!fHists)
    {
      cout << "ERROR: MShowSpect::PreProc(): " << fHistName << " not found!" << endl;
      exit(1);
    }
  
  return (kTRUE) ; 
} 


Bool_t MShowSpect::PostProcess()
{
  //   just start the gui for displaying the adc spectra

  new MGDisplayAdc(fHists, gClient->GetRoot(), gClient->GetRoot(), 600, 600);

  return (kTRUE) ; 
} 










