#ifndef MGSTARG_H
#define MGSTARG_H

#ifndef COSY_MGEmbeddedCanvas
#include "MGEmbeddedCanvas.h"
#endif

class TGraph;
class TLine;
class TText;

class ZdAz;

class MGStarg : public MGEmbeddedCanvas
{
    TLine  *fLin1;
    TLine  *fLin2;

    TText  *fTxt;

    TLine  *fBar;

    TGraph *fGraph;

    Double_t fTime;

    void DrawCoordinateSystem();

    void InitText();
    void InitCross();
    void InitBar();

    void UpdateCross(Float_t x, Float_t y);
    void UpdateText(Float_t acc);
    void UpdateGraph(Float_t acc);
    void Update(Float_t zd, Float_t x, Float_t y);

public:
    MGStarg(const TGWindow* p, const UInt_t w);
    ~MGStarg();

    void Update(ZdAz &pos, ZdAz &acc);

    ClassDef(MGStarg, 0)
};

#endif // MGSTARG_H
