#ifndef COSY_MPointing
#define COSY_MPointing

#include "coord.h"
#include "log.h"

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class Macs;
class MCosy;

class MPointing : public Log, public TObject
{
protected:
    MCosy *fCosy;

    bool SetAccDec(Macs *mac, Float_t acc, Float_t dec);
    bool Break();

private:
    Float_t fVel;
    Float_t fAcc;
    Float_t fDec;

    void DoRelPos(const ZdAz &rd, const Bool_t axe1, const Bool_t axe2);
    void SetPosVelocity(const Float_t ratio, Float_t vel);

public:
    MPointing(MCosy *cosy, const Log &log) : Log(log), fCosy(cosy), fVel(0.1), fAcc(0.2), fDec(0.1) { }

    void SetPointAccDec(Float_t acc, Float_t dec) { fAcc = acc; fDec = dec; }
    void SetPointVelocity(Float_t vel) { fVel = vel; }
    int  SetPosition(const ZdAz &dst, Bool_t track=kFALSE);
  
    ClassDef(MPointing, 0)
};

#endif
