#ifndef COSY_Filter2
#define COSY_Filter2

#ifndef __CINT__
#include <TROOT.h>
#endif

typedef unsigned char byte;

class MStarList;

class Filter2
{
    static void  DrawBox(const int x1, const int y1,
                         const int x2, const int y2,
                         byte *buffer, const int col);

    static void  MarkPoint(const int x, const int y,
                           byte *buffer, const int col);

    static float Mean(const byte *buffer, const int offset,
                      int *min, int *max);

    static float SDev(const byte *buffer, const int offset,
                      const double mean);

    static int   GetMeanPosition(const byte *bitmap,
                                 const int x, const int y, const int box,
                                 Double_t &mx, Double_t &my);

public:
    static void Execute(MStarList &list, byte *img);

    ClassDef(Filter2, 0)
};

#endif
