
#ifndef ROOT_Rtypes
#define ROOT_Rtypes

// Copyright (C) 1994 CodeCERN. All rights reserved.

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// Rtypes                                                               //
//                                                                      //
// Basic types used by ROOT.                                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


#ifndef ROOT_RConfig
//*KEEP,RConfig.
#include "RConfig.h"
//*KEND.
#endif

#include <stdio.h>

//*KEEP,DllImport,T=C.
#include "DllImport.h"
//*KEND.

//---- types -------------------------------------------------------------------

typedef char           Char_t;      //Signed Character 1 byte
typedef unsigned char  UChar_t;     //Unsigned Character 1 byte
typedef short          Short_t;     //Signed Short integer 2 bytes
typedef unsigned short UShort_t;    //Unsigned Short integer 2 bytes
#ifdef R__INT16
typedef long           Int_t;       //Signed integer 4 bytes
typedef unsigned long  UInt_t;      //Unsigned integer 4 bytes
#else
typedef int            Int_t;       //Signed integer 4 bytes
typedef unsigned int   UInt_t;      //Unsigned integer 4 bytes
#endif
#ifdef R__B64
typedef int            Seek_t;      //File pointer
typedef long           Long_t;      //Signed long integer 4 bytes
typedef unsigned long  ULong_t;     //Unsigned long integer 4 bytes
#else
typedef int            Seek_t;      //File pointer
typedef long           Long_t;      //Signed long integer 8 bytes
typedef unsigned long  ULong_t;     //Unsigned long integer 8 bytes
#endif
typedef float          Float_t;     //Float 4 bytes
typedef double         Double_t;    //Float 8 bytes
typedef char           Text_t;      //General string
typedef unsigned char  Bool_t;      //Boolean (0=false, 1=true)
typedef unsigned char  Byte_t;      //Byte (8 bits)
typedef short          Version_t;   //Class version identifier
typedef char           Option_t;    //Option string
typedef int            Ssiz_t;      //String size
typedef float          Real_t;      //TVector and TMatrix element type

typedef void         (*VoidFuncPtr_t)();  //pointer to void function


//---- constants ---------------------------------------------------------------

#ifndef NULL
#define NULL 0
#endif

const Bool_t kTRUE   = 1;
const Bool_t kFALSE  = 0;

const Int_t  kMaxInt      = 2147483647;
const Int_t  kMaxShort    = 32767;
const size_t kBitsPerByte = 8;
const Ssiz_t kNPOS        = ~(Ssiz_t)0;


//--- bit manipulation ---------------------------------------------------------

#define BIT(n)       (1 << (n))
#define SETBIT(n,i)  ((n) |= BIT(i))
#define CLRBIT(n,i)  ((n) &= ~BIT(i))
#define TESTBIT(n,i) ((Bool_t)(((n) & BIT(i)) != 0))


//---- debug global ------------------------------------------------------------

EXTERN Bool_t gDebug;


//---- ClassDef macros ---------------------------------------------------------

class TClass;
class TBuffer;
class TMemberInspector;

extern TClass *CreateClass(const char *cname, Version_t id,
                           const char *dfil, const char *ifil,
                           Int_t dl, Int_t il);

#define ClassDef(name,id) \
private: \
  static TClass *fgIsA; \
public: \
  static const char *DeclFileName() { return __FILE__; } \
  static int DeclFileLine() { return __LINE__; } \
  static const char *ImplFileName(); \
  static int ImplFileLine(); \
  static Version_t Class_Version() { return id; } \
  static TClass *Class(); \
  static void Dictionary(); \
  virtual TClass *IsA() const { return name::Class(); } \
  virtual void ShowMembers(TMemberInspector &insp, char *parent); \
  virtual void Streamer(TBuffer &b); \
  friend TBuffer &operator>>(TBuffer &buf, name *&obj);

#define _ClassInit_(name) \
   extern void AddClass(const char *cname, Version_t id, VoidFuncPtr_t dict); \
   extern void RemoveClass(const char *cname); \
   class _NAME3_(__,name,Init__) { \
      public: \
         _NAME3_(__,name,Init__)() { \
            AddClass(_QUOTE_(name), name::Class_Version(), \
                     &name::Dictionary); \
         } \
         ~_NAME3_(__,name,Init__)() { \
            RemoveClass(_QUOTE_(name)); \
         } \
   }; \
   static _NAME3_(__,name,Init__) _NAME3_(__g,name,Init__);

#define _ClassImp_(name) \
   TClass *name::Class() \
          { if (!fgIsA) name::Dictionary(); return fgIsA; } \
   const char *name::ImplFileName() { return __FILE__; } \
   int name::ImplFileLine() { return __LINE__; } \
   TClass *name::fgIsA = 0; \
   _ClassInit_(name)

#define ClassImp(name) \
   void name::Dictionary() \
   { \
      TClass *c = CreateClass(_QUOTE_(name), Class_Version(), \
                              DeclFileName(), ImplFileName(), \
                              DeclFileLine(), ImplFileLine()); \
      fgIsA = c; \
   } \
   _ClassImp_(name)

#endif

