#ifndef MARS_MEnv
#define MARS_MEnv

#ifndef ROOT_TEnv
#include <TEnv.h>
#endif

#ifndef ROOT_TOrdCollection
#include <TOrdCollection.h>
#endif

class TAttLine;
class TAttMarker;
class TAttText;
class TAttFill;

class MEnv : public TEnv
{
private:
    TOrdCollection fChecked;

    TString Compile(TString str, const char *post) const;

public:
    MEnv(const char *name="") : TEnv(name) { fChecked.SetOwner(); }

    Int_t       GetValue(const char *name, Int_t dflt);
    Double_t    GetValue(const char *name, Double_t dflt);
    const char *GetValue(const char *name, const char *dflt);

    Int_t       GetColor(const char *name, Int_t dftl);

    void        GetAttributes(const char *name, TObject *obj, TObject *dftl=0);
    void        GetAttLine(const char *name, TAttLine &line, TAttLine *dftl=0);
    void        GetAttText(const char *name, TAttText &text, TAttText *dftl=0);
    void        GetAttFill(const char *name, TAttFill &fill, TAttFill *dftl=0);
    void        GetAttMarker(const char *name, TAttMarker &marker, TAttMarker *dftl=0);

    void PrintUntouched() const;

    ClassDef(MEnv, 0) // A slightly more advanced version of TEnv
};
    
#endif

