/***************************************************************************
                          videospot.h  -  description
                             -------------------
    begin                : Thu Aug 28 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEOSPOT_H
#define VIDEOSPOT_H

#include <qobject.h>

/**
  *@author Martin Merck
  */

class VideoSpot : public QObject
{
public:
	VideoSpot();
	VideoSpot(  double p_iX, double p_iY, int p_iNumPixel  );

  VideoSpot( const VideoSpot& p_Spot );
  VideoSpot& operator=( const VideoSpot& p_Spot );

	virtual ~VideoSpot();
  /** No descriptions */
  virtual bool contains( int p_iX, int p_iY );
  /** No descriptions */
  virtual bool contains2( int p_iX, int p_iY );
  /** No descriptions */
  virtual void append( int p_iX, int p_iY, int p_iWeight );
  /** No descriptions */
  virtual double getX();
  /** No descriptions */
  virtual double getY();
  /** No descriptions */
  virtual int getNumPixel() { return m_iNumPixel; }
  /** No descriptions */
  virtual bool isValid();

private: // Private attributes
  /**  */
  int m_iXSum;
  /**  */
  int m_iYSum;
  /**  */
  int m_iNumPixel;
  /**  */
  int m_iWSum;
};

#endif
