// MotorThreadController.cpp: Implementierung der Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "defocusthreadcontroller.h"
#include "defocusthread.h"
#include "amcmirrorpanel.h"
#include <qthread.h>

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

DefocusThreadController::DefocusThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
: ThreadController( p_qlPanels, p_pReceiver )
{
}

DefocusThreadController::~DefocusThreadController()
{

}

void DefocusThreadController::run()
{
	for( AMCMirrorPanel* pActualPanel = m_qlPanels.first();
		 pActualPanel; pActualPanel = m_qlPanels.next() )
	{
		if( m_zStop )
			return;
		DefocusThread* pThread = new DefocusThread( m_pReceiver );
		pThread->setPanel( pActualPanel );
		pThread->start();
		pThread->wait();
		delete pThread;
	}

	return;
}
