<?php
{
    function CreateQuery($_GET, $alias, $checkwhere, $checkgroup, $checkstatusgroup, $needs)
    {
        $fromtable="Sequences";

        $groups = 0;
        foreach ($checkgroup as $element)
            if ($element==-1)
                $groups++;

        $statusgroups = 0;
        foreach ($checkstatusgroup as $element)
            if ($element==-1)
                $statusgroups++;

        $query0 = "SELECT ";

        if ($groups>0)
        {
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                    $query0 .=  $key . " as '" . $alias[$key] . "' " . ", ";
            //--------------------------------------------------
            $query0 .= "SUM(fRunTime)/3600 as '" . $alias["SUM(fRunTime)/3600"] . "', ";
            //--------------------------------------------------
            $query0 .= " SUM(fNumEvents) as '" . $alias["SUM(fNumEvents)"] . "', ";
            $query0 .= " Min(fZenithDistanceMin) as '" . $alias["Min(fZenithDistanceMin)"] . "', ";
            $query0 .= " Max(fZenithDistanceMax) as '" . $alias["Max(fZenithDistanceMax)"] . "', ";
            $query0 .= " COUNT(*) as 'Sequence' ";
        }
        else
        {
            if ($statusgroups>0)
            {
                foreach ($checkstatusgroup as $key => $element)
                    if ($element==-1)
                        $query0 .= " (if(IsNull(" . $key . "), if(isnull(fStartTime), 'not done', if(isnull(fFailedTime),if(isnull(" . $needs[$key] . "),'not done',if(date_sub(Now(),interval 12 hour) < fStartTime,'running','crashed')),if(isnull(" . $needs[$key] . "),'not done','failed'))) ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";
//                        $query0 .= " (if(IsNull(" . $key . "), 'not done' ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";

                $query0 .= " count(*) as 'Sequence'";

            }
            else
            {
                if (!empty($_GET["fSendTxt"]))
                    $query0 .= " " . $fromtable . ".fSequenceFirst as '" . $alias["fSequenceFirst"] . "' ";
                else
                {
                    $query0 .= " CONCAT('<A&ws;HREF=\"runinfo.php?',  'fRunStart=On', '&fZenithDistance=On', '&fRunMin=', Sequences.fSequenceFirst, '&fMeanTriggerRate=On', '&fRunTypeName=On', '&fRunMax=', fSequenceLast, '&fNumEvents=On', '&fSourceName=On&', 'fExcludedFDAKEY=1', '&fSequenceFirst=On', '&fRawFileAvail=On', '&fCCFileAvail=On', '&fCaCoFileAvail=On', '&fNumResults=500\">', Sequences.fSequenceFirst, '</A>') ";
                    $query0 .= " as " . $alias["fSequenceFirst"];
                    if (!empty($_GET["fLinks"]))
                    {
                        $query0 .= ", CONCAT('<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/callisto/' , LEFT(LPAD(CONCAT(Sequences.fSequenceFirst, '.'), 9,'0'),4), '/', LPAD(CONCAT(Sequences.fSequenceFirst, '/'), 9,'0'), 'callisto', LPAD(CONCAT(Sequences.fSequenceFirst , '.html'), 13,'0') , '\">cl</A>'";
                        $query0 .= ", '&nbsp;<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/callisto/' , LEFT(LPAD(CONCAT(Sequences.fSequenceFirst, '.'), 9,'0'),4), '/', LPAD(CONCAT(Sequences.fSequenceFirst, '/'), 9,'0'), '\">c</A>'";
                        $query0 .= ", '&nbsp;<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/star/' , LEFT(LPAD(CONCAT(Sequences.fSequenceFirst, '.'), 9,'0'),4), '/', LPAD(CONCAT(Sequences.fSequenceFirst, '/'), 9,'0'), 'star', LPAD(CONCAT(Sequences.fSequenceFirst , '.html'), 13,'0') , '\">sl</A>'";
                        $query0 .= ", '&nbsp;<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/star/' , LEFT(LPAD(CONCAT(Sequences.fSequenceFirst, '.'), 9,'0'),4), '/', LPAD(CONCAT(Sequences.fSequenceFirst, '/'), 9,'0'), '\">s</A>'";
                        $query0 .= ", '&nbsp;<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/sequences/' , LEFT(LPAD(CONCAT(Sequences.fSequenceFirst, '.'), 9,'0'),4), '/sequence', LPAD(CONCAT(Sequences.fSequenceFirst , '.txt'), 12,'0') , '\">', 'f </A>') ";
                        $query0 .= " as 'Links'";
                    }
                }

                foreach ($_GET as $key => $element)
                    if ($_GET[$key]=="On")
                        if ($key!="fLinks" && $key!="fOff" && $key!="fOnlyOff")
                            if (empty($checkwhere[$key]) || $checkwhere[$key]==0)
                                $query0 .= ", " . $key . " as '" . $alias[$key] . "' ";
            }
        }

        $query0 .= " FROM " . $fromtable;

        $query0 .= " LEFT JOIN SequenceProcessStatus ON Sequences.fSequenceFirst=SequenceProcessStatus.fSequenceFirst ";
        $query0 .= " LEFT JOIN Calibration ON Sequences.fSequenceFirst=Calibration.fSequenceFirst ";
        $query0 .= " LEFT JOIN Star ON Sequences.fSequenceFirst=Star.fSequenceFirst ";

        foreach ($_GET as $key => $element)
            if (($_GET[$key]=="On" || $groups>0))// && !empty(GetJoin($fromtable,$key)))
                $query0 .= GetJoin($fromtable,$key);

        if ($_GET["fOff"]=="Off")
        {
            if (strpos($query0, " WHERE ")==FALSE)
                $query0 .= " WHERE ";
            else
                $query0 .= " AND ";

            $query0 .= " NOT (fSourceName like '%Off%')";
        }

        if ($_GET["fOnlyOff"]=="On")
        {
            if (strpos($query0, " WHERE ")==FALSE)
                $query0 .= " WHERE ";
            else
                $query0 .= " AND ";

            $query0 .= " fSourceName like '%Off%'";
        }

        foreach ($checkwhere as $key => $element)
        {
            if (empty($element) || $element<=0)
                continue;

            if (strpos($query0, " WHERE ")==FALSE)
                $query0 .= " WHERE ";
            else
                if ($element!=-1)
                    if (strrpos($query0, " AND ")!=strlen($query0)-5)
                        $query0 .= " AND ";

            if ($element!=-1)
                $query0 .= GetCheck($fromtable, $key) . "=" . $element;
        }

        if (strpos($query0, " WHERE ")==FALSE)
            $query0 .= " WHERE ";
        else
            $query0 .= " AND ";

        $query0 .= StatusQuery("fStar", $needs);

        if (!empty($_GET["fRunMin"]) && !empty($_GET["fRunMax"]))
            $query0 .= "Sequences.fSequenceFirst BETWEEN " . $_GET["fRunMin"] . " AND " . $_GET["fRunMax"] . " ";
        else
            $query0 = substr($query0, 0, -4);

/*
        if (!empty($_GET["fDate"]))
            $query0 .= " AND fRunStart REGEXP \"^" . $_GET["fDate"] . "\" ";
*/

        if (!empty($_GET["fSourceN"]))
            $query0 .= " AND fSourceName REGEXP \"^" . $_GET["fSourceN"] . "\" ";

        if (!empty($_GET["fStartDate"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0 || !strpos(strrev($query0), " DNA "))
                $query0 .= " AND ";

            $startdate=substr($_GET["fStartDate"], 0, 10);
            if ($startdate=="0000-00-00")
                $query0 .=" fRunStart >= '" . $startdate . " 00:00:00' ";
            else
                $query0 .= " fRunStart >= ADDDATE('" . $startdate . " 13:00:00', INTERVAL -1 DAY) ";
        }

        if (!empty($_GET["fStopDate"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0 || !strpos(strrev($query0), " DNA "))
                $query0 .= " AND ";

            $stopdate=substr($_GET["fStopDate"], 0, 10);
            $query0 .= " fRunStart < '" . $stopdate . " 13:00:00' ";
        }

        if (!empty($_GET["fStarStart"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0 || !strpos(strrev($query0), " DNA "))
                $query0 .= " AND ";

            $starstart=substr($_GET["fStarStart"], 0, 10);
            $query0 .=" fStar >= '" . $starstart . " 00:00:00' ";
        }

        if (!empty($_GET["fStarStop"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0 || !strpos(strrev($query0), " DNA "))
                $query0 .= " AND ";

            $starstop=substr($_GET["fStarStop"], 0, 10);
            $query0 .= " fStar < '" . $starstop . " 23:59:59' ";
        }

        if ($groups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $groups;
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= GetCheck($fromtable,$key);
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if ($statusgroups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $statusgroups;
            foreach ($checkstatusgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= $alias[$key];
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if (!empty($_GET["fSortBy"]))
        {
            $val=substr($_GET["fSortBy"], 0, -1);
            $query0 .= " ORDER BY " . GetTable($fromtable,$val) . " ";
            if (substr($_GET["fSortBy"], -1)=="-")
                $query0 .= "DESC";
        }

        if (empty($_GET["fSortBy"]) && $groups==0 && $statusgroups==0)
            $query0 .= "ORDER BY Sequences.fSequenceFirst ASC ";

        if (empty($_GET["fNumStart"]))
            $_GET["fNumStart"]=0;

        if (empty($_GET["fSendTxt"]))
            $query0 .= " LIMIT " . $_GET["fNumStart"] . ", " . $_GET["fNumResults"];

        return $query0;
    }

    function InitGet($_GET)
    {
        // Find out whether it is the first call to the php script
        $first = empty($_GET["fRunMin"]) && empty($_GET["fRunMax"]);

        if (empty($_GET["fNumResults"]))
            $_GET["fNumResults"]="50";

        if (empty($_GET["fLastUpdate"]))
            $_GET["fLastUpdate"]="Off";

        if (empty($_GET["fNumEvents"]))
            $_GET["fNumEvents"]="Off";

        if (empty($_GET["fRunStart"]))
            $_GET["fRunStart"]=$first?"On":"";

        if (empty($_GET["fRunTime/60"]))
            $_GET["fRunTime/60"]=$first?"On":"";

        if (empty($_GET["fSequenceLast"]))
            $_GET["fSequenceLast"]="Off";

        if (empty($_GET["fLinks"]))
            $_GET["fLinks"]=$first?"On":"";

        if (empty($_GET["fOff"]))
            $_GET["fOff"]=$first?"On":"Off";

        if (empty($_GET["fOnlyOff"]))
            $_GET["fOnlyOff"]=$first?"Off":"";

        if (empty($_GET["fArrTimeLimitMean"]))
            $_GET["fArrTimeLimitMean"]="";

        if (empty($_GET["fArrTimeLimitRms"]))
            $_GET["fArrTimeLimitRms"]="";

        if (empty($_GET["fPedRmsInLimitMean"]))
            $_GET["fPedRmsInLimitMean"]="";

        if (empty($_GET["fPedRmsInLimitRms"]))
            $_GET["fPedRmsInLimitRms"]="";

        if (empty($_GET["fMuonRateLimitMean"]))
            $_GET["fMuonRateLimitMean"]="";

        if (empty($_GET["fMuonRateLimitRms"]))
            $_GET["fMuonRateLimitRms"]="";

        if (empty($_GET["fImgRateLimitMean"]))
            $_GET["fImgRateLimitMean"]="";

        if (empty($_GET["fImgRateLimitRms"]))
            $_GET["fImgRateLimitRms"]="";

        if (empty($_GET["fPSFLimitMean"]))
            $_GET["fPSFLimitMean"]="";

        if (empty($_GET["fPSFLimitRms"]))
            $_GET["fPSFLimitRms"]="";

        if (empty($_GET["fUnsInLimitMean"]))
            $_GET["fUnsInLimitMean"]="";

        if (empty($_GET["fZdMinLimitMean"]))
            $_GET["fZdMinLimitMean"]="";

        if (empty($_GET["fZdMaxLimitMean"]))
            $_GET["fZdMaxLimitMean"]="";

        if (empty($_GET["fAzimuthMin"]))
            $_GET["fAzimuthMin"]="Off";

        if (empty($_GET["fAzimuthMax"]))
            $_GET["fAzimuthMax"]="Off";

        if (empty($_GET["fZenithDistanceMin"]))
            $_GET["fZenithDistanceMin"]=$first?"On":"";

        if (empty($_GET["fZenithDistanceMax"]))
            $_GET["fZenithDistanceMax"]=$first?"On":"";

        if (empty($_GET["fSourceName"]))
            $_GET["fSourceName"]="On";

        if (empty($_GET["fManuallyChangedName"]))
            $_GET["fManuallyChangedName"]="Off";

        if (empty($_GET["fLightConditionsName"]))
            $_GET["fLightConditionsName"]=$first?"On":"";

        if (empty($_GET["fDiscriminatorThresholdTableName"]))
            $_GET["fDiscriminatorThresholdTableName"]="Off";

        if (empty($_GET["fStar"]))
            $_GET["fStar"]="Off";

        if (empty($_GET["fStarStatus"]))
            $_GET["fStarStatus"]=$first?"1":"";

        if (empty($_GET["fUnreliableInner"]))
            $_GET["fUnreliableInner"]="Off";

        if (empty($_GET["fUnsuitableOuter"]))
            $_GET["fUnsuitableOuter"]="Off";

        if (empty($_GET["fUnreliableOuter"]))
            $_GET["fUnreliableOuter"]="Off";

        if (empty($_GET["fUnsuitableInner"]))
            $_GET["fUnsuitableInner"]=$first?"On":"";

        if (empty($_GET["fIsolatedInner"]))
            $_GET["fIsolatedInner"]="Off";

        if (empty($_GET["fIsolatedOuter"]))
            $_GET["fIsolatedOuter"]="Off";

        if (empty($_GET["fMeanPedRmsInner"]))
            $_GET["fMeanPedRmsInner"]=$first?"On":"";

        if (empty($_GET["fMeanPedRmsOuter"]))
            $_GET["fMeanPedRmsOuter"]="Off";

        if (empty($_GET["fIsolatedMaxCluster"]))
            $_GET["fIsolatedMaxCluster"]="Off";

        if (empty($_GET["fArrTimeMeanInner"]))
            $_GET["fArrTimeMeanInner"]="Off";

        if (empty($_GET["fArrTimeMeanOuter"]))
            $_GET["fArrTimeMeanOuter"]="Off";

        if (empty($_GET["fArrTimeRmsInner"]))
            $_GET["fArrTimeRmsInner"]=$first?"On":"";

        if (empty($_GET["fArrTimeRmsOuter"]))
            $_GET["fArrTimeRmsOuter"]="Off";

        if (empty($_GET["fConvFactorInner"]))
            $_GET["fConvFactorInner"]=$first?"On":"";

        if (empty($_GET["fConvFactorOuter"]))
            $_GET["fConvFactorOuter"]="Off";

        if (empty($_GET["fMeanNumberIslands"]))
            $_GET["fMeanNumberIslands"]="Off";

        if (empty($_GET["fPSF"]))
            $_GET["fPSF"]=$first?"On":"";

        if (empty($_GET["fRatio"]))
            $_GET["fRatio"]="Off";

        if (empty($_GET["fMuonNumber"]))
            $_GET["fMuonNumber"]="Off";

        if (empty($_GET["fEffOnTime"]))
            $_GET["fEffOnTime"]=$first?"On":"";

        if (empty($_GET["fEffOnTime/fRunTime"]))
            $_GET["fEffOnTime/fRunTime"]=$first?"On":"";

        if (empty($_GET["fMuonRate"]))
            $_GET["fMuonRate"]=$first?"On":"";

        if (empty($_GET["fDataRate"]))
            $_GET["fDataRate"]=$first?"On":"";

        if (empty($_GET["fMaxHumidity"]))
            $_GET["fMaxHumidity"]="Off";

    }

    function PrintForm($_GET, $host, $user, $pw, $db, $limits, $rms, $alias)
    {
        printf("<center>\n");
        printf("<form action=\"findoffdata.php\" METHOD=\"GET\">\n");

        printf(" <table>\n");
        printf("  <tr><td align='center'>\n");


        printf(" <table>\n");
        printf("  <tr>\n");

        CheckBox("fRunStart",          "Start time");
        CheckBox("fSequenceLast",      "Last run");
        CheckBox("fZenithDistanceMin", "Zd min");
        CheckBox("fZenithDistanceMax", "Zd max");

        printf("  </tr><tr>\n");

        CheckBox("fNumEvents",         "Num of events");
        CheckBox("fRunTime/60",        "Duration");
        CheckBox("fAzimuthMin",        "Azimuth min");
        CheckBox("fAzimuthMax",        "Azimuth max");
//        CheckBox("fLinks",             "Links");
/*
        printf("  </tr></table>\n");
        printf(" <p>\n");
        printf(" <table>\n");
        printf("  <tr>\n");
*/

        printf("  </tr><tr>\n");

        CheckBox("fUnsuitableInner",     "Unsuitable inner");
        CheckBox("fUnsuitableOuter",     "Unsuitable outer");
        CheckBox("fUnreliableInner",     "Unreliable inner");
        CheckBox("fUnreliableOuter",     "Unreliable outer");

        printf("  </tr><tr>\n");

        CheckBox("fIsolatedInner",       "Isolated inner");
        CheckBox("fIsolatedOuter",       "Isolated outer");
        CheckBox("fIsolatedMaxCluster",  "IsolatedMaxCl.");
        CheckBox("fMaxHumidity",        "MaxHumidity");

        printf("  </tr><tr>\n");

        CheckBox("fArrTimeMeanInner",    "ArrTimeMean in");
        CheckBox("fArrTimeMeanOuter",    "ArrTimeMean out");
        CheckBox("fArrTimeRmsInner",     "ArrTimeRms in");
        CheckBox("fArrTimeRmsOuter",     "ArrTimeRms out");

        printf("  </tr><tr>\n");

        CheckBox("fConvFactorInner",     "Conv inner ");
        CheckBox("fConvFactorOuter",     "Conv outer ");
        CheckBox("fMeanPedRmsInner",     "MeanPedRms in");
        CheckBox("fMeanPedRmsOuter",     "MeanPedRms out");

/*
        printf(" </tr></table>\n");
        printf(" <p>\n");

        printf(" <table>\n");
        printf("  <tr>\n");
*/

        printf("  </tr><tr>\n");

        CheckBox("fMeanNumberIslands",  "MeanNumIslands");
        CheckBox("fPSF",                "PSF");
        CheckBox("fRatio",              "Ratio");
        CheckBox("fMuonRate",           "MuonRate");

        printf("  </tr><tr>\n");

        CheckBox("fMuonNumber",         "MuonNumber");
        CheckBox("fEffOnTime",          "EffOnTime");
        CheckBox("fEffOnTime/fRunTime", "RelOnTime");
        CheckBox("fDataRate",           "CleanedEvtRate");

        printf("  </tr>\n");
        printf(" </table>\n");
        printf(" <p>\n");

        printf(" <table><tr><td>\n");

        PrintPullDown($host, $user, $pw, $db, "Source",                      "fSourceName",                      "fSourceKEY",                      "Source Name");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "LightConditions",             "fLightConditionsName",             "fLightConditionsKEY",             "Light Conditions");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "DiscriminatorThresholdTable", "fDiscriminatorThresholdTableName", "fDiscriminatorThresholdTableKEY", "DT Table");
        printf("  </td></tr><tr><td>\n");
        PrintPullDown($host, $user, $pw, $db, "ManuallyChanged",             "fManuallyChangedName",             "fManuallyChangedKEY",             "Manually changed");
        printf("  </td><td>\n");
        PrintStatusMenu("fStar",                "Star");

        printf("</td></tr> </table>\n");
        printf(" <p>\n");

        printf("  </td><td valign='top'>\n");

        printf("  <table>\n");
        printf("  <tr><th colspan='3'>Limits</th><tr>\n");
        printf("  <tr><td>Name </td><td> Mean </td><td> Rms </td></tr>\n");
        PrintLimitsMenu($limits, $rms, $alias);
        printf("  </td></tr></table>\n");

        printf("  </td></tr><tr><td colspan='2' align='center'>\n");

        printf(" <p>\n");

        printf(" <table>\n");
        printf("  <tr><td>\n");

        if (empty($_GET["fStarStart"]))
            $starmin = GetMin("fStar", "SequenceProcessStatus", $host, $user, $pw, $db);
        else
            $starmin = $_GET["fStarStart"];

        if (empty($_GET["fStarStop"]))
            $starmax = GetMax("fStar", "SequenceProcessStatus", $host, $user, $pw, $db);
        else
            $starmax = $_GET["fStarStop"];

        printf("StarDone&nbsp;(yyyy-mm-dd)&nbsp;from&nbsp;<input name=\"fStarStart\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">\n", $starmin);
        printf("to&nbsp;<input name=\"fStarStop\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">&nbsp;&nbsp;&nbsp;&nbsp;\n", $starmax);
        printf("  </td>\n");
        CheckBox("fLinks",    "Links");
        CheckBox("fOff",      "incl. offsources");
        CheckBox("fOnlyOff",  "only offsources");

        printf("  </tr>\n");
        printf(" </table>\n");
        printf(" <p>\n");

        if (empty($_GET["fStartDate"]))
            $timemin = GetMin("fRunStart", "Sequences", $host, $user, $pw, $db);
        else
            $timemin = $_GET["fStartDate"];

        if (empty($_GET["fStopDate"]))
            $timemax = GetMax("fRunStart", "Sequences", $host, $user, $pw, $db);
        else
            $timemax = $_GET["fStopDate"];

        printf("Night&nbsp;(yyyy-mm-dd)&nbsp;from&nbsp;<input name=\"fStartDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">\n", $timemin);
        printf("to&nbsp;<input name=\"fStopDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">&nbsp;&nbsp;&nbsp;&nbsp;\n", $timemax);

        if (empty($_GET["fRunMin"]))
            $min = GetMin("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $min = $_GET["fRunMin"];

        if (empty($_GET["fRunMax"]))
            $max = GetMax("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $max = $_GET["fRunMax"];

/*
        printf("Date&nbsp;(yyyy-mm-dd)&nbsp;<input name=\"fDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"");
        if (!empty($_GET["fDate"]))
            printf("%s", $_GET["fDate"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");
*/

        printf("Sequences&nbsp;from&nbsp;<input name=\"fRunMin\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">\n", $min);
        printf("to&nbsp;<input name=\"fRunMax\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">&nbsp;&nbsp;&nbsp;\n", $max);

        printf(" <P>\n");

        printf("Source&nbsp;(<A HREF=\"regexp.html\">regexp</A>)&nbsp;<input name=\"fSourceN\" type=\"text\" size=\"15\" maxlength=\"15\" value=\"");
        if (!empty($_GET["fSourceN"]))
            printf("%s", $_GET["fSourceN"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");

        printf(" Results:\n");
        printf(" <select name=\"fNumResults\">\n");

        $numres = array("10", "20", "50", "100", "200", "500");
        foreach ($numres as $element)
        {
            if ($element==$_GET["fNumResults"])
                printf("<option value=\"%s\" selected>%3s</option>\n", $element, $element);
            else
                printf("<option value=\"%s\">%3s</option>\n", $element, $element);
        }
        printf(" </select>\n");
        printf(" &nbsp;&nbsp;&nbsp;\n");

        ini_set("mysql.trace_mode", "Off");
        ini_set("display_errors", "Off");

        printf("<input class='Width' type='submit' value='Query Table'>&nbsp;&nbsp;&nbsp;\n");
        printf("<input class='Width' type='button' value='Reset' onClick='self.location.href=\"findoffdata.php\"'>&nbsp;&nbsp;&nbsp;\n");
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Get .txt' onClick='self.location.href=\"%s&fSendTxt=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Print' onClick='self.location.href=\"%s&fPrintTable=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        printf("</form>\n");
        printf("</center>\n");


        printf("  </td></tr> </table>\n");

        printf("</td>\n");
        printf("</tr>\n");


        printf("<tr class='Block'>\n");
        printf("<td>\n");
    }

    function PrintPage($html, $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $limits, $rms, $needs)
    {
        $db_id = mysql_connect($host, $user, $pw);
        if ($db_id==FALSE)
        {
            printf("mysql_connect returned the following error: %s\n", mysql_error());
            die("");
        }
        mysql_select_db($db);

        $query0 = CreateQuery($_GET, $alias, $checkwhere, $checkgroup, $checkstatusgroup, $needs);

        $result0 = mysql_query($query0, $db_id);

        if ($result0)
        {
            if ($html=="1" || $html=="2")
                PrintMagicTable($result0, $alias, $rightalign, $limits, $rms, $_GET);
            else
                PrintText($result0);

            mysql_free_result($result0);
        }
        mysql_close($db_id);

        if ($html=="1")
            printf("<U><B>submitted query:</B></U><BR>%s<BR>", htmlspecialchars($query0));
    }

    include ("include.php");
    include ("db.php");
    include ("magicdefs.php");

    ini_set("display_errors", "On");
    ini_set("mysql.trace_mode", "On");

    if (!empty($_GET["fSendTxt"]))
    {
        header("Content-type: application/octet");
        header("Content-Disposition: attachment; filename=query-result.txt");

        PrintPage("0", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $limits, $rms, $needs);
    }
    else
    {
        echo (file_get_contents("index-header.html"));

        $environment = sizeof($_GET);

        InitGet($_GET);
        if (empty($_GET["fPrintTable"]))
            PrintForm($_GET, $host, $user, $pw, $db, $limits, $rms, $alias);

        if ($environment==0)
            printf("No query submitted yet.<BR>");
        else
        {
            if (empty($_GET["fPrintTable"]))
                PrintPage("1", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $limits, $rms, $needs);
            else
                PrintPage("2", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $limits, $rms, $needs);
        }

        echo (file_get_contents("index-footer.html"));
    }

    ini_set("display_errors", "Off");
    ini_set("mysql.trace_mode", "Off");
}
?>
