// MotorThreadController.cpp: Implementierung der Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "motorthreadcontroller.h"
#include "motorthread.h"
#include "amcmirrorpanel.h"
#include <qthread.h>

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

MotorThreadController::MotorThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
: m_qlPanels( p_qlPanels ), m_pReceiver( p_pReceiver )
{
}

MotorThreadController::~MotorThreadController()
{

}

void MotorThreadController::run()
{
	for( AMCMirrorPanel* pActualPanel = m_qlPanels.first();
		 pActualPanel; pActualPanel = m_qlPanels.next() )
	{
		MotorThread* pThread = new MotorThread( m_pReceiver );
		pThread->setPanel( pActualPanel );
		pThread->start();
		pThread->wait();
		delete pThread;
	}

	return;
}
