//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGCoordinates.h"

#include <iostream.h>  // cout

#include "MGCoordinate.h"
#include "coord.h"

ClassImp(MGCoordinates);

MGCoordinates::MGCoordinates(const TGWindow* p,
                             const Int_t type,
                             const Int_t flag,
                             const Int_t deg1, const UInt_t min1, const UInt_t sec1,
                             const Int_t deg2, const UInt_t min2, const UInt_t sec2)
: TGFrame(p, 244, 76, kFixedSize)
{
    const Int_t t    = type==kETypeZdAz ? kETypeDeg : kETypeH;
    const char *txt1 = type==kETypeZdAz ? "Zenith Dist [\xb0]:" : "Right Ascension [h]:";
    const char *txt2 = type==kETypeZdAz ? "Azimuth [\xb0]:"     : "Declination [\xb0]:";

    // p = pointer to MainFrame (not owner)
    fX = new MGCoordinate(this, t, flag, flag>1?"":txt1, deg1, min1, sec1);
    fX->Move(0, 0);

    fY = new MGCoordinate(this, kETypeDeg, flag, flag>1?"":txt2, deg2, min2, sec2);
    fY->Move(125, 0);

    MapWindow();
}

MGCoordinates::~MGCoordinates()
{
    delete fY;
    delete fX;

    cout << "MGCoordinates destroyed." << endl;
}

XY MGCoordinates::GetCoordinates() const
{
    return XY(fX->GetVal(), fY->GetVal());
}

void MGCoordinates::SetCoordinates(const XY &xy)
{
    fX->SetVal(xy.X());
    fY->SetVal(xy.Y());
}

void MGCoordinates::Print()
{
    fX->Print();
    fY->Print();
}
