/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Daniela Dorner, 05/2005 <mailto:dorner@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2006
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// checkstardone.C
// ===============
//
// check the availability of the star files for one sequence:
// if star has been executed successfully, this information has been inserted
// into the database (SequenceProcessStatus) with this macro this information
// is checked 
//
// executing the macro:
//  .x checkstardone.C+("sequencenumber")
//
// the macro returns 0, if there's no connection to the database, 2, if a
// file is missing, and 1 if all files are there
// the return value is checked by the script, that executes the macro
//
// this macro is very similar to the macro checkfileavail.C
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <fstream>

#include <TEnv.h>

#include <MSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>

using namespace std;


//check the value of a column for a sequence
TString GetStatus(MSQLServer &serv, TEnv &rc, TString primary, TString table, TString column)
{
    TString query(Form("SELECT %s FROM %s WHERE %s=%s",
                       column.Data(), table.Data(),
                       rc.GetValue(table+".Primary", ""),
                       primary.Data()));

    cout << "Query: " << query << endl;

    TSQLResult *res = serv.Query(query);
    if (!res)
    {
        cout << "Error - no sequence to check" << endl;
        return "";
    }

    TString rc = (*row)[0];

    delete res;

    return rc;
}

int checkstardone(TString datasetno)
{
    TEnv env("sql.rc");

    MSQLServer serv(env);
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }
    cout << "checkstardone" << endl;
    cout << "-------------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    TEnv rc("steps.rc");

    //check if fStar not NULL for sequence 
    if (GetStatus(serv, rc, datasetno, "SequenceProcessStatus", "fStar").IsNull())
        return 2;

    return 1;
}

