#ifndef MARS_MFTriggerPattern
#define MARS_MFTriggerPattern

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MTriggerPattern;

class MFTriggerPattern : public MFilter
{
public:
    enum Prescale_t {
        kUnPrescaled,
        kPrescaled
    };

private:
  MTriggerPattern *fPattern;        //!
  
  Byte_t fMaskRequiredPrescaled;    // Mask for filtering Trigger Pattern allowed
  Byte_t fMaskRequiredUnprescaled;  // Mask for filtering Trigger Pattern allowed
  Byte_t fMaskDeniedPrescaled;      // Mask for filtering Trigger Pattern denied
  Byte_t fMaskDeniedUnprescaled;    // Mask for filtering Trigger Pattern denied

  Bool_t fDefault;                  // Default which is used if trigger pattern has default value (p==0&&u==0)
  Bool_t fResult;                   //!
  
  Int_t PreProcess(MParList *pList);
  Int_t Process();
  
  Bool_t IsExpressionTrue() const;
  
public:
  MFTriggerPattern(const char *name=NULL, const char *title=NULL);
  MFTriggerPattern(MFTriggerPattern &trigpatt);
    
  void RequireTriggerLvl1(Prescale_t prescaled=kUnPrescaled);
  void RequireTriggerLvl2(Prescale_t prescaled=kUnPrescaled);
  void RequireCalibration(Prescale_t prescaled=kUnPrescaled);
  void RequirePedestal(Prescale_t prescaled=kUnPrescaled);
  void RequirePinDiode(Prescale_t prescaled=kUnPrescaled);
  
  void DenyTriggerLvl1(Prescale_t prescaled=kUnPrescaled);
  void DenyTriggerLvl2(Prescale_t prescaled=kUnPrescaled);
  void DenyCalibration(Prescale_t prescaled=kUnPrescaled);
  void DenyPedestal(Prescale_t prescaled=kUnPrescaled);
  void DenyPinDiode(Prescale_t prescaled=kUnPrescaled);
  
  void Require(TString patt, Prescale_t prescaled=kUnPrescaled);
  void Deny(TString patt, Prescale_t prescaled=kUnPrescaled);

  void SetDefault(Bool_t b) { fDefault=b; }

  // Low level settings. USE THESE ONLY IF YOU ARE AN EXPERT!
  void SetMaskRequired(const Byte_t mask, Prescale_t prescaled=kUnPrescaled);
  void SetMaskDenied(const Byte_t mask, Prescale_t prescaled=kUnPrescaled);
  
  ClassDef(MFTriggerPattern, 1) // A Filter for the Trigger Pattern
};
    
#endif
