#ifndef MRAWFILEWRITE_H
#define MRAWFILEWRITE_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class TFile;
class TTree;

class MTime;
class MParList;
class MRawRunHeader;
class MRawEvtHeader;
class MRawCrateArray;
class MRawEvtData;

class MRawFileWrite : public MTask
{
private:
    MParList *pParList;             

    MTime          *fRawEvtTime;    
    MRawRunHeader  *fRawRunHeader;  
    MRawEvtHeader  *fRawEvtHeader;  
    MRawEvtData    *fRawEvtData;    
    MRawCrateArray *fRawCrateArray; 

    TTree *fTData;                  //!
    TTree *fTPedestal;              //!
    TTree *fTCalibration;           //!

    TFile *fOut;                    //!

public:
    MRawFileWrite(const char *fname,
                  Option_t *opt="UPDATE",
                  const char *ftitle="Unnamed",
                  Int_t comp=9,
                  const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MRawFileWrite, 0)	// Task to write the raw data containers to a root file
};

#endif
