/////////////////////////////////////////////////////////////////
//
// MCEventHeader_2
//
//  Created: Sat Oct 19 12:11:43 CEST 2002
//  Author:  Oscar Blanch Bigas
//  Purpose: Base class for reflector 0.6 EventHeader
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt MCEventHeader_2.cxx}

// @subsection Class {\em MCEventHeader_2}: Implementation

// @code

#include "MCEventHeader_2.hxx"

void MCEventHeader_2::transport( COREventHeader *e )
{
  EvtNumber      = e->EvtNumber;
  PrimaryID      = e->PrimaryID;
  Etotal         = e->Etotal;
  Thick0         = e->Thick0;
  FirstTarget    = e->FirstTarget;
  zFirstInt      = e->zFirstInt;
  Theta          = e->Theta;
  Phi            = e->Phi;
  NumRndSeq      = e->NumRndSeq;
  RunNumber      = e->RunNumber;
  DateRun        = e->DateRun;
  VersionPGM     = e->VersionPGM;
  NumObsLev      = e->NumObsLev;
  SlopeSpec      = e->SlopeSpec;
  ELowLim        = e->ELowLim;
  EUppLim        = e->EUppLim;
  ThetaMin       = e->ThetaMin;
  ThetaMax       = e->ThetaMax;
  PhiMin         = e->PhiMin;
  PhiMax         = e->PhiMax;
  CWaveLower     = e->CWaveLower;
  CWaveUpper     = e->CWaveUpper;

  memcpy( p, e->p, 3*sizeof(Float_t) );
  memcpy( RndData, e->RndData, 30*sizeof(Float_t) );
  memcpy( HeightLev, e->HeightLev, 10*sizeof(Float_t) );
  memcpy( CorePos, e->CorePos, 40*sizeof(Float_t) );
}

// @endcode
