void traindisp()
{
    MDataSet set("mctesttrain.txt");
    set.SetNumAnalysis(1);            // Necessary

    MJTrainDisp opt;
    //opt.SetDebug();

    // ------- Parameters to train Random Forest --------
    opt.AddParameter("MHillas.fLength");
    opt.AddParameter("MHillas.fWidth");
    opt.AddParameter("MHillas.fSize");
    opt.AddParameter("MNewImagePar.fLeakage1");
    opt.AddParameter("MNewImagePar.fLeakage2");
    opt.AddParameter("MNewImagePar.fConc");
    opt.AddParameter("MNewImagePar.fConc1");
    opt.AddParameter("MPointingPos.fZd");
    opt.AddParameter("MNewImagePar.fUsedArea");
    opt.AddParameter("MNewImagePar.fCoreArea");
    opt.AddParameter("MNewImagePar.fNumUsedPixels");
    opt.AddParameter("MNewImagePar.fNumCorePixels");
    opt.AddParameter("MImagePar.fSizeSinglePixels");
    opt.AddParameter("MHillasExt.fM3Long*sign(MHillasSrc.fCosDeltaAlpha)");
    opt.AddParameter("MHillasExt.fAsym*sign(MHillasSrc.fCosDeltaAlpha)");

    // -------------------- Run ----------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    /*
     -------------------- Magic-Cuts ----------------------
     MFMagicCuts cuts;
     cuts.SetHadronnessCut(MFMagicCuts::kArea);
     cuts.SetThetaCut(MFMagicCuts::kOn);

     TArrayD arr(10);
     arr[0]=  1.3245;
     arr[1]=  0.208700;
     arr[2]=  0.229200;
     arr[3]=  5.305200;
     arr[4]=  0.098930;
     arr[5]= -0.082950;
     arr[6]=  8.2957;
     arr[7]=  0.8677;

     cuts.SetVariables(arr);

     opt.AddPreCut(&cuts);

     -------------------- Energy Slope --------------------
     MFEnergySlope slope(-2.8);
     opt.AddPreCut(&slope);

     -------------------- Other cuts ----------------------
     opt.AddPreCut("MNewImagePar.fLeakage1<0.0001");
    */

     opt.AddPreCut("MHillas.fSize>200");
     opt.AddPreCut("MHillasSrc.fDCA*MGeomCam.fConvMm2Deg<0.3");

     // The number is the number of events read from the file
     // randomly and is the number of events before cuts
     opt.Train("rf-disp.root", set, 30000);
}
/*
 // SequencesOn:   Monte Carlo Sequences used for training
 // SequencesOff:  Monte Carlo Sequences used for testing

 // Use:
 // opt.AddPreCut    to use cut for test and training
 // opt.AddTestCut   to use cut for test only
 // opt.AddTrainCut  to use cut for train only
 */
