void optimonoff()
{
    MJOptimizeCuts opt("MHThetaSq");
    opt.SetDebug(2);
    opt.SetOptimizer(MJOptimize::kSimplex);

    // ------------------- Xi -----------------------
    opt.FixParameter(0, 1.3245);
    opt.FixParameter(6, 8.2957);
    opt.FixParameter(7, 0.8677);

    // --------------- Theta Sq ---------------------
    opt.SetParameter(1, 0.204);

    // ----------------- Area -----------------------
    opt.SetParameter(2, 0.215);
    opt.SetParameter(3, 5.486);
    opt.SetParameter(4, 0.0897);

    // ----------------- M3L ------------------------
    opt.FixParameter(5, -0.07);

    // ----------------- Fit ------------------------

    MAlphaFitter fit;
    fit.SetScaleMode(MAlphaFitter::kBackground);
    fit.SetBackgroundFitMin(0.137);
    fit.SetBackgroundFitMax(0.640);
    fit.SetPolynomOrder(1);
    fit.SetSignalFunction(MAlphaFitter::kThetaSq);
    fit.SetMinimizationStrategy(MAlphaFitter::kSignificanceLogExcess);

    // ----------------- Cuts -----------------------

    MFMagicCuts cuts;
    cuts.SetThetaCut(MFMagicCuts::kNone);

    // ---------------- Quality-Cuts ----------------

    opt.AddPreCut("MNewImagePar.fNumUsedPixels>5");
    opt.AddPreCut("(MNewImagePar.fLeakage1 < 0.3)");
    opt.AddPreCut("(MImagePar.fNumSatPixelsLG<2)");
    opt.AddPreCut("(MImagePar.fNumIslands<3)");
    opt.AddPreCut("(log10(MNewImagePar.fConc1) < (-0.371)*log10(MHillas.fSize) + 0.596)");
    opt.AddPreCut("(MImagePar.fNumSatPixelsHG < 1) || (MHillas.GetArea*(MGeomCam.fConvMm2Deg^2) > (0.003*MImagePar.fNumSatPixelsHG) + 0.0325)");

    // ----------------------------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    opt.RunOnOff("ganymed00000001-summary.root", &cuts, &fit);
}
