/***************************************************************************
                          amccmdstate.cpp  -  description
                             -------------------
    begin                : Tue Jul 27 2004
    copyright            : (C) 2004 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "amccmdstate.h"

AMCCmdState::AMCCmdState(QObject *parent, const char *name ) : QObject( parent, name )
{
	m_qsCmdStateTxtTable[AMC_CMD_STATE_NOCMD]           = new QString( "No Command received from CC" );
	m_qsCmdStateTxtTable[AMC_CMD_STATE_ACKNOWLEDGED]    = new QString( "Command acknowledged" );
	m_qsCmdStateTxtTable[AMC_CMD_STATE_NOTACKNOWLEDGED] = new QString( "Command not acknowledged" );
	m_qsCmdStateTxtTable[AMC_CMD_STATE_ABORTED]         = new QString( "Command aborted" );
	m_qsCmdStateTxtTable[AMC_CMD_STATE_COMPLETED]       = new QString( "Command completed" );
	m_qsCmdStateTxtTable[AMC_CMD_STATE_INVALID]         = new QString( "Invalid command received from CC" );
	m_qsCmdStateTxtTable[AMC_CMD_STATE_UNKNOWN]         = new QString( "Unknown command state" );

	m_iState = AMC_CMD_STATE_NOCMD;
}

AMCCmdState::~AMCCmdState()
{
	for( int i=AMC_CMD_STATE_NOCMD; i<=AMC_CMD_STATE_UNKNOWN; i++ )
  {
  	delete  m_qsCmdStateTxtTable[i];
		m_qsCmdStateTxtTable[i] = 0;
  }
}

/** Set the state. */
void AMCCmdState::setState( int p_iState )
{
  // if the new state is equal to the actual state we
  // do nothing.
	if( p_iState == m_iState )
		return;

	int iOldState = m_iState;
	m_iState = p_iState;

	emit stateChanged( iOldState, m_iState );
}

/** Return the actual state. */
int AMCCmdState::getState() const
{
	return m_iState;
}

/** Get a textual description of the state. */
const QString& AMCCmdState::getText( int p_iState ) const
{
	if ( ( p_iState < AMC_CMD_STATE_NOCMD )
				||
			 ( p_iState > AMC_CMD_STATE_UNKNOWN ) )
		return( *m_qsCmdStateTxtTable[ AMC_CMD_STATE_UNKNOWN ] );
	else
		return( *m_qsCmdStateTxtTable[ p_iState ] );
}
