/*-----------------------------------------------------------------------------
calconf.h -- CAL Configuration

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 94/10/11 by Soenke Hansen
Version 1.15 of 99/06/18

Macros defining the capabilities of the CAL implementation.

-----------------------------------------------------------------------------*/


#ifndef calconf_DEFINED
#define calconf_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

/* ICANOS configuration is also needed */
#include "icanconf.h"

/*------- Capabilities, CAL Classes implemented ----------------------------*/

/* CAPS_NET bits: Capabilities a CAL network may have */
#define CAP_NET_MNGMT	0x01	/* Network Management */
#define CAP_NET_ERROR	0x02	/* Network Error */
#define CAP_NET_CONFIG	0x04	/* Network Configuration */

/* CAPS_NODE bits: Capabilities a NMT Slave may have */
#define CAP_NODE_MNGMT	0x01	/* Node Management capability */
#define CAP_NODE_ERROR	0x02	/* Node Error capability */
#define CAP_NODE_CONFIG	0x04	/* Node Configuration capability */
#define CAP_NODE_MASTER	0x10	/* NMT Master capability */

/* CAPS_DBT bits: Capabilities a DBT Slave may have */
#define CAP_DBT_DISTRIB	0x01	/* Distribution capability */
#define CAP_DBT_CONSIST	0x02	/* Consistency capability */
#define CAP_DBT_MASTER	0x10	/* DBT Master capability */

/* CAPS_LMT bits: Capabilities a LMT Slave may have */
#define CAP_LMT_BASIC	0x01	/* LMT class 1 */
#define CAP_LMT_ADDR	0x02	/* LMT class 2 (with LMT address) */
#define CAP_LMT_MASTER	0x10	/* LMT Master capability */

/* CAPS_CMS bits: Kinds of CMS objects supported */
#define CAP_CMS_BVAR1	0x01	/* CMS Basic Variables using 1 COB */
#define CAP_CMS_BVAR2	0x02	/* CMS Basic Variables using 2 COB's */
#define CAP_CMS_MVAR	0x04	/* CMS Multiplexed Variables */
#define CAP_CMS_EVT1	0x08	/* CMS Events using 1 COB */
#define CAP_CMS_EVT2	0x10	/* CMS Events using 2 COB's */
#define CAP_CMS_DOM	0x20	/* CMS Domains (Basic and Multiplexed) */

/* The following definitions determine what the node implements.
   NOTE: The values chosen will effect the code size. */

/* Default Node Class */
#ifndef CAPS_NODE
#define CAPS_NODE	CAP_NODE_MNGMT + CAP_NODE_ERROR \
			/* + CAP_NODE_CONFIG */ + CAP_NODE_MASTER
#endif

/* Network implementation - only relevant when CAP_NODE_MASTER defined
   in CAPS_NODE */
#ifndef CAPS_NET
#define CAPS_NET	CAP_NET_MNGMT
#endif

/* DBT implementation */
#ifndef CAPS_DBT
#define CAPS_DBT	CAP_DBT_DISTRIB + CAP_DBT_CONSIST + CAP_DBT_MASTER
#endif

/* LMT implementation */
#ifndef CAPS_LMT
#define CAPS_LMT	CAP_LMT_BASIC + CAP_LMT_ADDR
#endif

/* CMS implementation */
#ifndef CAPS_CMS
#define CAPS_CMS	CAP_CMS_BVAR1 + CAP_CMS_BVAR1 + CAP_CMS_EVT1 \
			+ CAP_CMS_EVT2 + CAP_CMS_DOM + CAP_CMS_MVAR
#endif

/* Does the node have the capability to store parameters in
   non-volatile memory? */
#define CAPS_STORE	1	/* 1: yes, 0: no */

/*------- Memory functions -------------------------------------------------*/

/* Compare and copy arrays of unsigned characters */
extern int umemcmp(unsigned char *, unsigned char *, int);
extern void umemcpy(unsigned char *, unsigned char *, int);
extern void umemset(unsigned char *, unsigned char, int);

/*------- Interfacing to CANopen Object dictionary  ------------------------*/
/* 
 * #define this, if CAL and CANopen runs on the same 
 * system (without DPM like on VMOD-ICAN /CAN-104)
 */
#ifdef BIGBOX
#define CAL_CANOPEN_CLAMPED
#endif

#ifdef __cplusplus
}
#endif

#endif /* !calconf_DEFINED */
