/***************************************************************************
                          videospotthread.h  -  description
                             -------------------
    begin                : Sat Aug 30 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEOSPOTTHREAD_H
#define VIDEOSPOTTHREAD_H

#include <qthread.h>
#include <qlist.h>
#include <qrect.h>

class VideoSpot;

/**
  *@author Martin Merck
  */

class VideoSpotThread : public QThread
{
public:
	VideoSpotThread( QObject* p_pReceiver, QImage* p_pImage, uchar* p_pDark );
	virtual ~VideoSpotThread();

  /** No descriptions */
  bool isActive();

  /** No descriptions */
  virtual void wake();

  /** No descriptions */
  virtual void stop();

  /** No descriptions */
  virtual void subtractDarks();
  /** No descriptions */
  virtual void rescaleImage();
  /** No descriptions */
  virtual void findSpot();
  /** No descriptions */
	virtual int getThreshold();
  /** No descriptions */
	virtual void getSpotList( QList<VideoSpot>* p_pSpots );
  /** No descriptions */
	virtual void getFrame( uchar* p_pData );
  /** No descriptions */
  virtual void setScalingMax( int p_iVal ) { m_iScaleMax = p_iVal; };
  /** No descriptions */
  virtual void setScaling( bool p_zOn ) { m_zScale = p_zOn; };
  /** No descriptions */
  virtual void setDarkSubtract( bool p_zOn ) { m_zDarks = p_zOn; };
  /** No descriptions */
  virtual void setSigmas( int p_iSigmas ) { m_iSigmas = p_iSigmas; };
  /** No descriptions */
	virtual void setROI( QRect& p_qrRect) { m_qrROI = p_qrRect; };

protected: // Protected methods
  /** No descriptions */
  virtual void run();

private: // Private attributes
  /**  */
	QObject* m_pReceiver;
  /**  */
  QImage* m_pImage;
  /**  */
  uchar* m_pDark;
  /**  */
  uchar* m_pData;
  /**  */
	QList<VideoSpot> m_qlSpotList;
  /**  */
	QMutex m_aMutex;
  /**  */
	QMutex m_aDataMutex;
  /**  */
	QWaitCondition m_aWaitCondition;
	/** */
  bool m_zStop;
	/** */
  bool m_zIsActive;
  /**  */
  bool m_zDarks;
  /**  */
  bool m_zScale;
	/** */
	int m_iScaleMax;
	/** */
	QRect m_qrROI;
	/** */
	int m_iSigmas;
};

#endif
