#ifndef MARS_MPedestalSubtractedEvt
#define MARS_MPedestalSubtractedEvt

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MArrayF
#include "MArrayF.h"
#endif
#ifndef MARS_MArrayB
#include "MArrayB.h"
#endif

class MPedestalSubtractedEvt : public MParContainer, public MCamEvent
{
private:
    MArrayF fSamples;        // list of all samples with pedestal subtracted
    MArrayB fSamplesRaw;     // list of all samples (raw)

    UInt_t fNumSamples;      // number of samples per pixel
    UInt_t fNumPixels;       // number of pixels

public:
    MPedestalSubtractedEvt(const char *name=NULL, const char *title=NULL)
        : fNumSamples(0), fNumPixels(0)
    {
    }

    void InitSize(const UInt_t i) { fNumPixels=i; }
    void InitSamples(UInt_t samples, UInt_t pixels=0);

    Float_t *GetSamples(UInt_t pixel) const;
    Byte_t *GetSamplesRaw(UInt_t pixel) const;

    UInt_t   GetNumSamples() const { return fNumSamples; }
    UShort_t GetNumPixels() const  { return fNumPixels; }

    Int_t GetSaturation(const Int_t idx, Int_t limit, Int_t &first, Int_t &last) const;
    //void  InterpolateSaturation(const Int_t idx, Int_t limit, Int_t first, Int_t last) const;
    Int_t GetMax(const Int_t pixidx, const Int_t first, const Int_t last, UInt_t &val) const;
    Int_t GetMax(const Int_t pixidx, const Int_t first, const Int_t last) const
    {
        UInt_t val;
        return GetMax(pixidx, first, last, val);
    }
    Int_t GetMax(const Int_t pixidx, UInt_t &val) const
    {
        return GetMax(pixidx, 0, fNumSamples, val);
    }

    Int_t GetMax(const Int_t pixidx) const
    {
        UInt_t val;
        return GetMax(pixidx, 0, fNumSamples, val);
    }
    Int_t GetSaturation(const Int_t pixidx, Int_t limit) const
    {
        Int_t first=0;
        Int_t last=fNumSamples;
        return GetSaturation(pixidx, limit, first, last);
    }

    Int_t GetIntegralRaw(Int_t idx, Int_t first, Int_t last) const
    {
        Byte_t *ptr = GetSamplesRaw(idx);

        const Byte_t *end = ptr + last - first + 1;

        Int_t sum = 0;
        while (ptr<end)
            sum += *ptr++;

        return sum;
    }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const { return kTRUE; }
    void   DrawPixelContent(Int_t num) const { }

    ClassDef(MPedestalSubtractedEvt, 6) //Container to store the raw Event Data
};

#endif
